/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing;

import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;
import org.w3c.dom.Element;

public class DeliverOrderRequest
extends AbstractOrderProcessingRequest {
    public DeliverOrderRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "deliver-order");
    }

    public DeliverOrderRequest(MerchantInfo merchantInfo, String googleOrderNumber) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
    }

    public DeliverOrderRequest(MerchantInfo merchantInfo, String googleOrderNumber, String carrier, String trackingNumber, boolean sendEmail) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setCarrier(carrier);
        this.setTrackingNumber(trackingNumber);
        this.setSendEmail(sendEmail);
    }

    public String getCarrier() {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        return Utils.getElementStringValue(this.getDocument(), trackingDataTag, "carrier");
    }

    public String getTrackingNo() {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        return Utils.getElementStringValue(this.getDocument(), trackingDataTag, "tracking-number");
    }

    public String getTrackingNumber() {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        return Utils.getElementStringValue(this.getDocument(), trackingDataTag, "tracking-number");
    }

    public boolean isSendEmail() {
        return Utils.getElementBooleanValue(this.getDocument(), this.getRoot(), "send-email");
    }

    public void setCarrier(String carrier) {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), trackingDataTag, "carrier", carrier);
    }

    public void setSendEmail(boolean sendEmail) {
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "send-email", sendEmail);
    }

    public void setTrackingNo(String trackingNo) {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), trackingDataTag, "tracking-number", trackingNo);
    }

    public void setTrackingNumber(String trackingNumber) {
        if (trackingNumber == null) {
            throw new IllegalArgumentException("Tracking number cannot be null.");
        }
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), trackingDataTag, "tracking-number", trackingNumber);
    }
}

