/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing;

import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;
import org.w3c.dom.Element;

public class ChargeOrderRequest
extends AbstractOrderProcessingRequest {
    public ChargeOrderRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "charge-order");
    }

    public ChargeOrderRequest(MerchantInfo merchantInfo, String googleOrderNumber) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
    }

    public ChargeOrderRequest(MerchantInfo merchantInfo, String googleOrderNumber, float amount) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setAmount(amount);
    }

    public float getAmount() {
        return Utils.getElementFloatValue(this.getDocument(), this.getRoot(), "amount");
    }

    public void setAmount(float amount) {
        if (amount <= 0.0f) {
            throw new IllegalArgumentException("Charge amount must be greater than 0");
        }
        Element e = Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "amount", amount);
        e.setAttribute("currency", this.merchantInfo.getCurrencyCode());
    }
}

