/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing;

import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;

public class CancelOrderRequest
extends AbstractOrderProcessingRequest {
    public static final int CANCEL_STRING_LIMIT = 140;
    public static final String CANCEL_ERROR_STRING = "The cancel string limits have been exceeded. The reason and comment cannot exceed 140characters.";

    public CancelOrderRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "cancel-order");
    }

    public CancelOrderRequest(MerchantInfo merchantInfo, String googleOrderNumber, String reason) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setReason(reason);
    }

    public CancelOrderRequest(MerchantInfo merchantInfo, String googleOrderNo, String reason, String comment) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNo);
        this.setReason(reason);
        this.setComment(comment);
    }

    public boolean isWithinCancelStringLimits(String reason, String comment) {
        if (reason == null || comment == null) {
            throw new IllegalArgumentException(CANCEL_ERROR_STRING);
        }
        return reason.length() <= 140 && comment.length() <= 140;
    }

    public String getComment() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "comment");
    }

    public String getReason() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "reason");
    }

    public void setComment(String comment) {
        if (!this.isWithinCancelStringLimits("", comment)) {
            comment = comment.substring(0, 140);
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "comment", comment);
    }

    public void setReason(String reason) {
        if (!this.isWithinCancelStringLimits(reason, "")) {
            reason = reason.substring(0, 140);
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "reason", reason);
    }
}

