/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing;

import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;
import org.w3c.dom.Element;

public class AddTrackingDataRequest
extends AbstractOrderProcessingRequest {
    public AddTrackingDataRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "add-tracking-data");
    }

    public AddTrackingDataRequest(MerchantInfo merchantInfo, String googleOrderNumber, String carrier, String trackingNumber) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setCarrier(carrier);
        this.setTrackingNumber(trackingNumber);
    }

    public String getCarrier() {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        return Utils.getElementStringValue(this.getDocument(), trackingDataTag, "carrier");
    }

    public String getTrackingNo() {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        return Utils.getElementStringValue(this.getDocument(), trackingDataTag, "tracking-number");
    }

    public String getTrackingNumber() {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        return Utils.getElementStringValue(this.getDocument(), trackingDataTag, "tracking-number");
    }

    public void setCarrier(String carrier) {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), trackingDataTag, "carrier", carrier);
    }

    public void setTrackingNo(String trackingNo) {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), trackingDataTag, "tracking-number", trackingNo);
    }

    public void setTrackingNumber(String trackingNumber) {
        Element trackingDataTag = Utils.findContainerElseCreate(this.getDocument(), this.getRoot(), "tracking-data");
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), trackingDataTag, "tracking-number", trackingNumber);
    }
}

