/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.orderprocessing;

import com.google.checkout.CheckoutSystemException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.orderprocessing.AbstractOrderProcessingRequest;
import com.google.checkout.util.Utils;

public class AddMerchantOrderNumberRequest
extends AbstractOrderProcessingRequest {
    public AddMerchantOrderNumberRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "add-merchant-order-number");
    }

    public AddMerchantOrderNumberRequest(MerchantInfo merchantInfo, String googleOrderNumber, String merchantOrderNumber) {
        this(merchantInfo);
        this.setGoogleOrderNumber(googleOrderNumber);
        this.setMerchantOrderNumber(merchantOrderNumber);
    }

    public String getMerchantOrderNo() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "merchant-order-number");
    }

    public String getMerchantOrderNumber() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "merchant-order-number");
    }

    public void setMerchantOrderNo(String merchantOrderNo) {
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "merchant-order-number", merchantOrderNo);
    }

    public void setMerchantOrderNumber(String merchantOrderNumber) {
        if (merchantOrderNumber == null) {
            throw new CheckoutSystemException("MerchantOrderNumber cannot be null");
        }
        Utils.findElementAndSetElseCreateAndSet(this.getDocument(), this.getRoot(), "merchant-order-number", merchantOrderNumber);
    }
}

