/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.checkout.Item;
import com.google.checkout.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShoppingCart {
    private final Document document;
    private final Element shoppingCart;

    public ShoppingCart(Document document, Element shoppingCart) {
        this.document = document;
        this.shoppingCart = shoppingCart;
    }

    public Date getCartExpiration() throws CheckoutException {
        Element cartExpiration = Utils.findContainerElseCreate(this.document, this.shoppingCart, "cart-expiration");
        return Utils.getElementDateValue(this.document, cartExpiration, "good-until-date");
    }

    public Collection getItems() {
        Element items = Utils.findElementOrContainer(this.document, this.shoppingCart, "items");
        Element[] elements = Utils.getElements(this.document, items);
        ArrayList<Item> ret = new ArrayList<Item>();
        for (int i = 0; i < elements.length; ++i) {
            ret.add(new Item(this.document, elements[i]));
        }
        return ret;
    }

    public Element[] getMerchantPrivateDataNodes() {
        Element mpd = Utils.findElementOrContainer(this.document, this.shoppingCart, "merchant-private-data");
        if (mpd == null) {
            return null;
        }
        return Utils.getElements(this.document, mpd);
    }

    public void setMerchantPrivateDataNodes(Element[] elements) {
    }
}

