/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.notification.Address;
import com.google.checkout.notification.CheckoutNotification;
import com.google.checkout.notification.RiskInformation;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RiskInformationNotification
extends CheckoutNotification {
    private final Element riskInfo = Utils.findElementOrContainer(this.getDocument(), this.getRoot(), "risk-information");

    public RiskInformationNotification(String requestString) throws CheckoutException {
        this(Utils.newDocumentFromString(requestString));
    }

    public RiskInformationNotification(InputStream inputStream) throws CheckoutException {
        this(Utils.newDocumentFromInputStream(inputStream));
    }

    public RiskInformationNotification(Document document) {
        super(document);
    }

    public RiskInformation getRiskInfo() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element riskInformation = Utils.findElementOrContainer(document, root, "risk-information");
        return new RiskInformation(document, riskInformation);
    }

    public boolean isEligibleForProtection() {
        return Utils.getElementBooleanValue(this.getDocument(), this.riskInfo, "eligible-for-protection");
    }

    public Address getBillingAddress() {
        Element address = Utils.findElementOrContainer(this.getDocument(), this.riskInfo, "billing-address");
        return new Address(this.getDocument(), address);
    }

    public String getAvsResponse() {
        return Utils.getElementStringValue(this.getDocument(), this.riskInfo, "avs-response");
    }

    public String getCvnResponse() {
        return Utils.getElementStringValue(this.getDocument(), this.riskInfo, "cvn-response");
    }

    public String getPartialCcNumber() {
        return Utils.getElementStringValue(this.getDocument(), this.riskInfo, "partial-cc-number");
    }

    public int getBuyerAccountAge() {
        return Utils.getElementIntValue(this.getDocument(), this.riskInfo, "buyer-account-age");
    }

    public String getIpAddress() {
        return Utils.getElementStringValue(this.getDocument(), this.riskInfo, "ip-address");
    }
}

