/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.notification.Address;
import com.google.checkout.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RiskInformation {
    private final Document document;
    private final Element element;

    public RiskInformation(Document document, Element element) {
        this.document = document;
        this.element = element;
    }

    public boolean isEligibleForProtection() {
        return Utils.getElementBooleanValue(this.document, this.element, "eligible-for-protection");
    }

    public Address getBillingAddress() {
        Element address = Utils.findElementOrContainer(this.document, this.element, "billing-address");
        return new Address(this.document, address);
    }

    public String getAvsResponse() {
        return Utils.getElementStringValue(this.document, this.element, "avs-response");
    }

    public String getCvnResponse() {
        return Utils.getElementStringValue(this.document, this.element, "cvn-response");
    }

    public String getPartialCcNumber() {
        return Utils.getElementStringValue(this.document, this.element, "partial-cc-number");
    }

    public int getBuyerAccountAge() {
        return Utils.getElementIntValue(this.document, this.element, "buyer-account-age");
    }

    public String getIpAddress() {
        return Utils.getElementStringValue(this.document, this.element, "ip-address");
    }
}

