/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.notification.CheckoutNotification;
import com.google.checkout.notification.FinancialOrderState;
import com.google.checkout.notification.FulfillmentOrderState;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import org.w3c.dom.Document;

public class OrderStateChangeNotification
extends CheckoutNotification {
    public OrderStateChangeNotification(String requestString) throws CheckoutException {
        this(Utils.newDocumentFromString(requestString));
    }

    public OrderStateChangeNotification(InputStream inputStream) throws CheckoutException {
        this(Utils.newDocumentFromInputStream(inputStream));
    }

    public OrderStateChangeNotification(Document document) {
        super(document);
    }

    public FulfillmentOrderState getNewFulfillmentOrderState() {
        String state = Utils.getElementStringValue(this.getDocument(), this.getRoot(), "new-fulfillment-order-state");
        return FulfillmentOrderState.getState(state);
    }

    public FinancialOrderState getNewFinancialOrderState() {
        String state = Utils.getElementStringValue(this.getDocument(), this.getRoot(), "new-financial-order-state");
        return FinancialOrderState.getState(state);
    }

    public FulfillmentOrderState getPreviousFulfillmentOrderState() {
        String state = Utils.getElementStringValue(this.getDocument(), this.getRoot(), "previous-fulfillment-order-state");
        return FulfillmentOrderState.getState(state);
    }

    public FinancialOrderState getPreviousFinancialOrderState() {
        String state = Utils.getElementStringValue(this.getDocument(), this.getRoot(), "previous-financial-order-state");
        return FinancialOrderState.getState(state);
    }

    public String getReason() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "reason");
    }
}

