/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.notification.CarrierCalculatedShippingAdjustment;
import com.google.checkout.notification.CouponAdjustment;
import com.google.checkout.notification.FlatRateShippingAdjustment;
import com.google.checkout.notification.GiftCertificateAdjustment;
import com.google.checkout.notification.MerchantCalculatedShippingAdjustment;
import com.google.checkout.notification.MerchantCodes;
import com.google.checkout.notification.PickupShippingAdjustment;
import com.google.checkout.notification.Shipping;
import com.google.checkout.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OrderAdjustment {
    private final Document document;
    private final Element orderAdjustment;

    public OrderAdjustment(Document document, Element orderAdjustment) {
        this.document = document;
        this.orderAdjustment = orderAdjustment;
    }

    public boolean isMerchantCalculationSuccessful() {
        return Utils.getElementBooleanValue(this.document, this.orderAdjustment, "merchant-calculation-successful");
    }

    public float getAdjustmentTotal() {
        return Utils.getElementFloatValue(this.document, this.orderAdjustment, "adjustment-total");
    }

    public Collection getMerchantCodes() {
        Element mc = Utils.findElementOrContainer(this.document, this.orderAdjustment, "merchant-codes");
        Element[] elements = Utils.getElements(this.document, mc);
        ArrayList<MerchantCodes> ret = new ArrayList<MerchantCodes>();
        for (int i = 0; i < elements.length; ++i) {
            Element e = elements[i];
            String name = e.getNodeName();
            if ("gift-certificate-adjustment".equals(name)) {
                ret.add(new GiftCertificateAdjustment(this.document, e));
                continue;
            }
            if (!"coupon-adjustment".equals(name)) continue;
            ret.add(new CouponAdjustment(this.document, e));
        }
        return ret;
    }

    public Shipping getShipping() {
        Element shipping = Utils.findElementOrContainer(this.document, this.orderAdjustment, "shipping");
        Element e = Utils.findElementOrContainer(this.document, shipping, "merchant-calculated-shipping-adjustment");
        if (e != null) {
            return new MerchantCalculatedShippingAdjustment(this.document, e);
        }
        e = Utils.findElementOrContainer(this.document, shipping, "flat-rate-shipping-adjustment");
        if (e != null) {
            return new FlatRateShippingAdjustment(this.document, e);
        }
        e = Utils.findElementOrContainer(this.document, shipping, "pickup-shipping-adjustment");
        if (e != null) {
            return new PickupShippingAdjustment(this.document, e);
        }
        e = Utils.findElementOrContainer(this.document, shipping, "carrier-calculated-shipping-adjustment");
        if (e != null) {
            return new CarrierCalculatedShippingAdjustment(this.document, e);
        }
        return null;
    }

    public float getTotalTax() {
        return Utils.getElementFloatValue(this.document, this.orderAdjustment, "total-tax");
    }
}

