/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.checkout.Item;
import com.google.checkout.notification.Address;
import com.google.checkout.notification.BuyerMarketingPreferences;
import com.google.checkout.notification.CarrierCalculatedShippingAdjustment;
import com.google.checkout.notification.CheckoutNotification;
import com.google.checkout.notification.CouponAdjustment;
import com.google.checkout.notification.FinancialOrderState;
import com.google.checkout.notification.FlatRateShippingAdjustment;
import com.google.checkout.notification.FulfillmentOrderState;
import com.google.checkout.notification.GiftCertificateAdjustment;
import com.google.checkout.notification.MerchantCalculatedShippingAdjustment;
import com.google.checkout.notification.MerchantCodes;
import com.google.checkout.notification.OrderAdjustment;
import com.google.checkout.notification.PickupShippingAdjustment;
import com.google.checkout.notification.Promotion;
import com.google.checkout.notification.Shipping;
import com.google.checkout.notification.ShoppingCart;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewOrderNotification
extends CheckoutNotification {
    public NewOrderNotification(String requestString) throws CheckoutException {
        this(Utils.newDocumentFromString(requestString));
    }

    public NewOrderNotification(InputStream inputStream) throws CheckoutException {
        this(Utils.newDocumentFromInputStream(inputStream));
    }

    public NewOrderNotification(Document document) {
        super(document);
    }

    public Collection getItems() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element shoppingCart = Utils.findElementOrContainer(document, root, "shopping-cart");
        Element items = Utils.findElementOrContainer(document, shoppingCart, "items");
        Element[] elements = Utils.getElements(document, items);
        ArrayList<Item> ret = new ArrayList<Item>();
        for (int i = 0; i < elements.length; ++i) {
            ret.add(new Item(document, elements[i]));
        }
        return ret;
    }

    public ShoppingCart getShoppingCart() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element shoppingCart = Utils.findElementOrContainer(document, root, "shopping-cart");
        return new ShoppingCart(document, shoppingCart);
    }

    public Element[] getMerchantPrivateDataNodes() {
        Element root;
        Element shoppingCart;
        Document document = this.getDocument();
        Element mpd = Utils.findElementOrContainer(document, shoppingCart = Utils.findContainerElseCreate(document, root = this.getRoot(), "shopping-cart"), "merchant-private-data");
        if (mpd == null) {
            return null;
        }
        return Utils.getElements(document, mpd);
    }

    public Date getCartExpiration() throws CheckoutException {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element shoppingCart = Utils.findContainerElseCreate(document, root, "shopping-cart");
        Element cartExpiration = Utils.findContainerElseCreate(document, shoppingCart, "cart-expiration");
        return Utils.getElementDateValue(document, cartExpiration, "good-until-date");
    }

    public Address getBuyerShippingAddress() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element address = Utils.findElementOrContainer(document, root, "buyer-shipping-address");
        return new Address(document, address);
    }

    public Address getBuyerBillingAddress() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element address = Utils.findElementOrContainer(document, root, "buyer-billing-address");
        return new Address(document, address);
    }

    public BuyerMarketingPreferences getBuyerMarketingPreferences() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element buyerMarketingPreferences = Utils.findElementOrContainer(document, root, "buyer-marketing-preferences");
        return new BuyerMarketingPreferences(document, buyerMarketingPreferences);
    }

    public OrderAdjustment getOrderAdjustment() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element orderAdjustment = Utils.findElementOrContainer(document, root, "order-adjustment");
        return new OrderAdjustment(document, orderAdjustment);
    }

    public boolean isMarketingEmailAllowed() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element buyerMarketingPreferences = Utils.findElementOrContainer(document, root, "buyer-marketing-preferences");
        return Utils.getElementBooleanValue(document, buyerMarketingPreferences, "email-allowed");
    }

    public boolean isMerchantCalculationSuccessful() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element orderAdjustment = Utils.findElementOrContainer(document, root, "order-adjustment");
        return Utils.getElementBooleanValue(document, orderAdjustment, "merchant-calculation-successful");
    }

    public Collection getMerchantCodes() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element oa = Utils.findElementOrContainer(document, root, "order-adjustment");
        Element mc = Utils.findElementOrContainer(document, oa, "merchant-codes");
        Element[] elements = Utils.getElements(document, mc);
        ArrayList<MerchantCodes> ret = new ArrayList<MerchantCodes>();
        for (int i = 0; i < elements.length; ++i) {
            Element e = elements[i];
            String name = e.getNodeName();
            if ("gift-certificate-adjustment".equals(name)) {
                ret.add(new GiftCertificateAdjustment(document, e));
                continue;
            }
            if (!"coupon-adjustment".equals(name)) continue;
            ret.add(new CouponAdjustment(document, e));
        }
        return ret;
    }

    public float getTotalTax() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element orderAdjustment = Utils.findElementOrContainer(document, root, "order-adjustment");
        return Utils.getElementFloatValue(document, orderAdjustment, "total-tax");
    }

    public float getAdjustmentTotal() {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element orderAdjustment = Utils.findElementOrContainer(document, root, "order-adjustment");
        return Utils.getElementFloatValue(document, orderAdjustment, "adjustment-total");
    }

    public Shipping getShipping() {
        Element root;
        Element oa;
        Element shipping;
        Document document = this.getDocument();
        Element e = Utils.findElementOrContainer(document, shipping = Utils.findElementOrContainer(document, oa = Utils.findElementOrContainer(document, root = this.getRoot(), "order-adjustment"), "shipping"), "merchant-calculated-shipping-adjustment");
        if (e != null) {
            return new MerchantCalculatedShippingAdjustment(document, e);
        }
        e = Utils.findElementOrContainer(document, shipping, "flat-rate-shipping-adjustment");
        if (e != null) {
            return new FlatRateShippingAdjustment(document, e);
        }
        e = Utils.findElementOrContainer(document, shipping, "pickup-shipping-adjustment");
        if (e != null) {
            return new PickupShippingAdjustment(document, e);
        }
        e = Utils.findElementOrContainer(document, shipping, "carrier-calculated-shipping-adjustment");
        if (e != null) {
            return new CarrierCalculatedShippingAdjustment(document, e);
        }
        return null;
    }

    public float getOrderTotal() {
        return Utils.getElementFloatValue(this.getDocument(), this.getRoot(), "order-total");
    }

    public String getOrderCurrencyCode() {
        return Utils.findElementOrContainer(this.getDocument(), this.getRoot(), "order-total").getAttribute("currency");
    }

    public Collection getPromotions() {
        Element root;
        Document document = this.getDocument();
        Element promotions = Utils.findElementOrContainer(document, root = this.getRoot(), "promotions");
        if (promotions == null) {
            return null;
        }
        Element[] elements = Utils.getElements(document, promotions);
        ArrayList<Promotion> ret = new ArrayList<Promotion>();
        for (int i = 0; i < elements.length; ++i) {
            Element e = elements[i];
            ret.add(new Promotion(document, e));
        }
        return ret;
    }

    public FulfillmentOrderState getFulfillmentOrderState() {
        String state = Utils.getElementStringValue(this.getDocument(), this.getRoot(), "fulfillment-order-state");
        return FulfillmentOrderState.getState(state);
    }

    public FinancialOrderState getFinancialOrderState() {
        String state = Utils.getElementStringValue(this.getDocument(), this.getRoot(), "financial-order-state");
        return FinancialOrderState.getState(state);
    }

    public long getBuyerId() {
        return Utils.getElementLongValue(this.getDocument(), this.getRoot(), "buyer-id");
    }
}

