/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.notification.AuthorizationAmountNotification;
import com.google.checkout.notification.ChargeAmountNotification;
import com.google.checkout.notification.ChargebackAmountNotification;
import com.google.checkout.notification.CheckoutNotification;
import com.google.checkout.notification.CheckoutParserException;
import com.google.checkout.notification.NewOrderNotification;
import com.google.checkout.notification.NotificationParser;
import com.google.checkout.notification.OrderStateChangeNotification;
import com.google.checkout.notification.RefundAmountNotification;
import com.google.checkout.notification.RiskInformationNotification;
import com.google.checkout.util.Utils;
import java.util.HashMap;
import org.w3c.dom.Document;

public class CompositeNotificationParser
implements NotificationParser {
    private final HashMap notificationParsers = new HashMap();

    public CheckoutNotification parse(String xmlString) throws CheckoutParserException {
        CheckoutNotification notification;
        try {
            notification = this.parse(Utils.newDocumentFromString(xmlString));
        }
        catch (CheckoutException ex) {
            throw new CheckoutParserException(ex);
        }
        return notification;
    }

    public CheckoutNotification parse(Document xmlDocument) throws CheckoutParserException {
        String type = xmlDocument.getDocumentElement().getNodeName();
        NotificationParser parser = (NotificationParser)this.notificationParsers.get(type);
        if (parser == null) {
            throw new CheckoutParserException("Parser for type (" + type + ") " + "could not be found.");
        }
        return parser.parse(xmlDocument);
    }

    public void register(String notificationType, NotificationParser parser) {
        this.notificationParsers.put(notificationType, parser);
    }

    public static void registerDefaultNotificationParsers(CompositeNotificationParser parser) {
        parser.register("new-order-notification", new NotificationParser(){

            public CheckoutNotification parse(Document xmlDocument) {
                return new NewOrderNotification(xmlDocument);
            }
        });
        parser.register("risk-information-notification", new NotificationParser(){

            public CheckoutNotification parse(Document xmlDocument) {
                return new RiskInformationNotification(xmlDocument);
            }
        });
        parser.register("order-state-change-notification", new NotificationParser(){

            public CheckoutNotification parse(Document xmlDocument) {
                return new OrderStateChangeNotification(xmlDocument);
            }
        });
        parser.register("charge-amount-notification", new NotificationParser(){

            public CheckoutNotification parse(Document xmlDocument) {
                return new ChargeAmountNotification(xmlDocument);
            }
        });
        parser.register("refund-amount-notification", new NotificationParser(){

            public CheckoutNotification parse(Document xmlDocument) {
                return new RefundAmountNotification(xmlDocument);
            }
        });
        parser.register("chargeback-amount-notification", new NotificationParser(){

            public CheckoutNotification parse(Document xmlDocument) {
                return new ChargebackAmountNotification(xmlDocument);
            }
        });
        parser.register("authorization-amount-notification", new NotificationParser(){

            public CheckoutNotification parse(Document xmlDocument) {
                return new AuthorizationAmountNotification(xmlDocument);
            }
        });
    }
}

