/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.util.Utils;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class CheckoutNotification
implements Serializable {
    private final Document document;
    private final Element root;

    public CheckoutNotification(Document document) {
        this.document = document;
        this.root = document.getDocumentElement();
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRoot() {
        return this.root;
    }

    public String getGoogleOrderNo() {
        return Utils.getElementStringValue(this.document, this.root, "google-order-number");
    }

    public String getGoogleOrderNumber() {
        return Utils.getElementStringValue(this.document, this.root, "google-order-number");
    }

    public Date getTimestamp() throws CheckoutException {
        return Utils.getElementDateValue(this.document, this.root, "timestamp");
    }

    public String getType() {
        return this.getRootNodeName();
    }

    public String getSerialNumber() {
        return this.root.getAttribute("serial-number");
    }

    public String getXml() {
        return Utils.documentToString(this.document);
    }

    public String getXmlPretty() {
        return Utils.documentToStringPretty(this.document);
    }

    public String getRootNodeName() {
        return this.document.getDocumentElement().getNodeName();
    }
}

