/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.notification.CheckoutNotification;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import org.w3c.dom.Document;

public class ChargeAmountNotification
extends CheckoutNotification {
    public ChargeAmountNotification(String requestString) throws CheckoutException {
        this(Utils.newDocumentFromString(requestString));
    }

    public ChargeAmountNotification(InputStream inputStream) throws CheckoutException {
        this(Utils.newDocumentFromInputStream(inputStream));
    }

    public ChargeAmountNotification(Document document) {
        super(document);
    }

    public float getLatestChargeAmount() {
        return Utils.getElementFloatValue(this.getDocument(), this.getRoot(), "latest-charge-amount");
    }

    public float getLatestPromotionChargeAmount() {
        return Utils.getElementFloatValue(this.getDocument(), this.getRoot(), "latest-promotion-charge-amount");
    }

    public float getTotalChargeAmount() {
        return Utils.getElementFloatValue(this.getDocument(), this.getRoot(), "total-charge-amount");
    }

    public String getCurrencyCode() {
        return Utils.findElementOrContainer(this.getDocument(), this.getRoot(), "latest-charge-amount").getAttribute("currency");
    }
}

