/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.CheckoutException;
import com.google.checkout.notification.CheckoutNotification;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import java.util.Date;
import org.w3c.dom.Document;

public class AuthorizationAmountNotification
extends CheckoutNotification {
    public AuthorizationAmountNotification(String requestString) throws CheckoutException {
        this(Utils.newDocumentFromString(requestString));
    }

    public AuthorizationAmountNotification(InputStream inputStream) throws CheckoutException {
        this(Utils.newDocumentFromInputStream(inputStream));
    }

    public AuthorizationAmountNotification(Document document) {
        super(document);
    }

    public String getAvsResponse() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "avs-response");
    }

    public String getCvnResponse() {
        return Utils.getElementStringValue(this.getDocument(), this.getRoot(), "cvn-response");
    }

    public float getAuthorizationAmount() {
        return Utils.getElementFloatValue(this.getDocument(), this.getRoot(), "authorization-amount");
    }

    public String getCurrencyCode() {
        return Utils.findElementOrContainer(this.getDocument(), this.getRoot(), "authorization-amount").getAttribute("currency");
    }

    public Date getAuthorizationExpirationDate() throws CheckoutException {
        return Utils.getElementDateValue(this.getDocument(), this.getRoot(), "authorization-expiration-date");
    }
}

