/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.notification;

import com.google.checkout.notification.StructuredName;
import com.google.checkout.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Address {
    private final Document document;
    private final Element element;

    public Address(Document document, Element element) {
        this.document = document;
        this.element = element;
    }

    public String getAddress1() {
        return Utils.getElementStringValue(this.document, this.element, "address1");
    }

    public String getAddress2() {
        return Utils.getElementStringValue(this.document, this.element, "address2");
    }

    public String getCity() {
        return Utils.getElementStringValue(this.document, this.element, "city");
    }

    public String getCompanyName() {
        return Utils.getElementStringValue(this.document, this.element, "company-name");
    }

    public String getContactName() {
        return Utils.getElementStringValue(this.document, this.element, "contact-name");
    }

    public String getCountryCode() {
        return Utils.getElementStringValue(this.document, this.element, "country-code");
    }

    public String getEmail() {
        return Utils.getElementStringValue(this.document, this.element, "email");
    }

    public String getFax() {
        return Utils.getElementStringValue(this.document, this.element, "fax");
    }

    public String getPhone() {
        return Utils.getElementStringValue(this.document, this.element, "phone");
    }

    public String getPostalCode() {
        return Utils.getElementStringValue(this.document, this.element, "postal-code");
    }

    public String getRegion() {
        return Utils.getElementStringValue(this.document, this.element, "region");
    }

    public StructuredName getStructuredName() {
        Element structuredName = Utils.findElementOrContainer(this.document, this.element, "structured-name");
        if (structuredName != null) {
            return new StructuredName(this.document, structuredName);
        }
        return null;
    }
}

