/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.merchantcalculation;

import com.google.checkout.merchantcalculation.MerchantCodeResult;
import com.google.checkout.util.Utils;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MerchantCalculationResults {
    private final Document document = Utils.newEmptyDocument();
    private final Element root = this.document.createElementNS("http://checkout.google.com/schema/2", "merchant-calculation-results");
    private final Element results;

    public MerchantCalculationResults() {
        this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://checkout.google.com/schema/2");
        this.document.appendChild(this.root);
        this.results = this.document.createElement("results");
        this.root.appendChild(this.results);
    }

    public void addResult(String shippingName, String addressId, boolean shippable, double totalTaxAmount, double shippingRate, String currency, Collection merchantCodeResults) {
        this.addResult(shippingName, addressId, shippable, shippingRate, currency, merchantCodeResults);
        Element result = Utils.findElementOrContainer(this.document, this.results, "result");
        Element tax = Utils.createNewElementAndSet(this.document, result, "total-tax", totalTaxAmount);
        tax.setAttribute("currency", currency);
    }

    public void addResult(String shippingName, String addressId, boolean shippable, double shippingRate, String currency, Collection merchantCodeResults) {
        Element result = Utils.createNewContainer(this.document, this.results, "result");
        result.setAttribute("shipping-name", shippingName);
        result.setAttribute("address-id", addressId);
        Utils.createNewElementAndSet(this.document, result, "shippable", shippable);
        Element shipping = Utils.createNewElementAndSet(this.document, result, "shipping-rate", shippingRate);
        shipping.setAttribute("currency", currency);
        Element codes = Utils.createNewContainer(this.document, result, "merchant-code-results");
        if (merchantCodeResults != null) {
            for (MerchantCodeResult mcResult : merchantCodeResults) {
                Element eResult = Utils.createNewContainer(this.document, codes, mcResult.getType());
                Utils.createNewElementAndSet(this.document, eResult, "valid", mcResult.isValid());
                Utils.createNewElementAndSet(this.document, eResult, "calculated-amount", mcResult.getCalculatedAmount());
                Utils.createNewElementAndSet(this.document, eResult, "code", mcResult.getCode());
                Utils.createNewElementAndSet(this.document, eResult, "message", mcResult.getMessage());
            }
        }
    }

    protected Document getDocument() {
        return this.document;
    }

    public String getXml() {
        return Utils.documentToString(this.document);
    }

    public String getXmlPretty() {
        return Utils.documentToStringPretty(this.document);
    }
}

