/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.merchantcalculation;

import com.google.checkout.CheckoutException;
import com.google.checkout.checkout.Item;
import com.google.checkout.merchantcalculation.AnonymousAddress;
import com.google.checkout.merchantcalculation.CheckoutCallback;
import com.google.checkout.merchantcalculation.MerchantCodeString;
import com.google.checkout.notification.ShoppingCart;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MerchantCalculationCallback
extends CheckoutCallback {
    public MerchantCalculationCallback(String requestString) throws CheckoutException {
        this(Utils.newDocumentFromString(requestString));
    }

    public MerchantCalculationCallback(InputStream inputStream) throws CheckoutException {
        this(Utils.newDocumentFromInputStream(inputStream));
    }

    public MerchantCalculationCallback(Document document) {
        this.document = document;
        this.root = document.getDocumentElement();
    }

    public Collection getItems() {
        Element shoppingCart = Utils.findContainerElseCreate(this.document, this.root, "shopping-cart");
        Element items = Utils.findContainerElseCreate(this.document, shoppingCart, "items");
        Element[] elements = Utils.getElements(this.document, items);
        ArrayList<Item> ret = new ArrayList<Item>();
        for (int i = 0; i < elements.length; ++i) {
            ret.add(new Item(this.document, elements[i]));
        }
        return ret;
    }

    public ShoppingCart getShoppingCart() {
        Element shoppingCart = Utils.findElementOrContainer(this.document, this.root, "shopping-cart");
        return new ShoppingCart(this.document, shoppingCart);
    }

    public Element[] getMerchantPrivateDataNodes() {
        Element shoppingCart = Utils.findContainerElseCreate(this.document, this.root, "shopping-cart");
        Element mpd = Utils.findElementOrContainer(this.document, shoppingCart, "merchant-private-data");
        if (mpd == null) {
            return null;
        }
        return Utils.getElements(this.document, mpd);
    }

    public Date getCartExpiration() throws CheckoutException {
        Element shoppingCart = Utils.findContainerElseCreate(this.document, this.root, "shopping-cart");
        Element cartExpiration = Utils.findContainerElseCreate(this.document, shoppingCart, "cart-expiration");
        return Utils.getElementDateValue(this.document, cartExpiration, "good-until-date");
    }

    public long getBuyerId() {
        return Utils.getElementLongValue(this.document, this.root, "buyer-id");
    }

    public String getBuyerLanguage() {
        return Utils.getElementStringValue(this.document, this.root, "buyer-language");
    }

    public boolean isCalculateTax() {
        Element calculate = Utils.findContainerElseCreate(this.document, this.root, "calculate");
        return Utils.getElementBooleanValue(this.document, calculate, "tax");
    }

    public Collection getShippingMethods() {
        Element calculate = Utils.findContainerElseCreate(this.document, this.root, "calculate");
        Element shipping = Utils.findContainerElseCreate(this.document, calculate, "shipping");
        Element[] elements = Utils.getElements(this.document, shipping);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < elements.length; ++i) {
            ret.add(elements[i].getAttribute("name"));
        }
        return ret;
    }

    public Collection getMerchantCodes() {
        Element calculate = Utils.findContainerElseCreate(this.document, this.root, "calculate");
        Element merchantCodes = Utils.findContainerElseCreate(this.document, calculate, "merchant-code-strings");
        Element[] elements = Utils.getElements(this.document, merchantCodes);
        ArrayList<MerchantCodeString> ret = new ArrayList<MerchantCodeString>();
        for (int i = 0; i < elements.length; ++i) {
            ret.add(new MerchantCodeString(elements[i].getAttribute("code"), elements[i].getAttribute("pin")));
        }
        return ret;
    }

    public Collection getAnonymousAddresses() {
        Element calculate = Utils.findContainerElseCreate(this.document, this.root, "calculate");
        Element addresses = Utils.findContainerElseCreate(this.document, calculate, "addresses");
        Element[] elements = Utils.getElements(this.document, addresses);
        ArrayList<AnonymousAddress> ret = new ArrayList<AnonymousAddress>();
        for (int i = 0; i < elements.length; ++i) {
            ret.add(new AnonymousAddress(this.document, elements[i]));
        }
        return ret;
    }
}

