/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.handlers;

import com.google.checkout.CheckoutException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.handlers.MessageHandler;
import com.google.checkout.merchantcalculation.AnonymousAddress;
import com.google.checkout.merchantcalculation.CouponResult;
import com.google.checkout.merchantcalculation.MerchantCalculationCallback;
import com.google.checkout.merchantcalculation.MerchantCalculationResults;
import com.google.checkout.merchantcalculation.MerchantCodeString;
import java.util.ArrayList;
import java.util.Iterator;

public class MerchantCalculationCallbackHandler
implements MessageHandler {
    public String process(MerchantInfo mi, String callbackMsg) throws CheckoutException {
        try {
            MerchantCalculationCallback callback = new MerchantCalculationCallback(callbackMsg);
            Iterator addresses = callback.getAnonymousAddresses().iterator();
            MerchantCalculationResults results = new MerchantCalculationResults();
            while (addresses.hasNext()) {
                AnonymousAddress address = (AnonymousAddress)addresses.next();
                for (String shipping : callback.getShippingMethods()) {
                    Iterator merchantCodes = callback.getMerchantCodes().iterator();
                    ArrayList<CouponResult> codeResults = new ArrayList<CouponResult>();
                    while (merchantCodes.hasNext()) {
                        MerchantCodeString code = (MerchantCodeString)merchantCodes.next();
                        CouponResult coupon = new CouponResult(false, 0.0f, mi.getCurrencyCode(), code.getCode(), "Not supported in this example.");
                        codeResults.add(coupon);
                    }
                    results.addResult(shipping, address.getId(), true, 0.0, 0.0, mi.getCurrencyCode(), codeResults);
                }
            }
            return results.getXml();
        }
        catch (Exception e) {
            throw new CheckoutException(e);
        }
    }
}

