/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.handlers;

import com.google.checkout.MerchantInfo;
import com.google.checkout.handlers.CheckoutHandlerException;
import com.google.checkout.handlers.NotificationHandler;
import com.google.checkout.notification.CheckoutNotification;
import java.util.HashMap;

public class CompositeNotificationHandler
implements NotificationHandler {
    private HashMap notificationHandlers = new HashMap();

    public void handle(MerchantInfo mi, CheckoutNotification notification) throws CheckoutHandlerException {
        NotificationHandler handler = (NotificationHandler)this.notificationHandlers.get(notification.getType());
        if (handler == null) {
            throw new CheckoutHandlerException("Could not find handler for the notification type: " + notification.getType());
        }
        handler.handle(mi, notification);
    }

    public void register(String notificationType, NotificationHandler notificationHandler) {
        this.notificationHandlers.put(notificationType, notificationHandler);
    }
}

