/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.handlers;

import com.google.checkout.CheckoutException;
import com.google.checkout.GoogleOrder;
import com.google.checkout.MerchantInfo;
import com.google.checkout.handlers.MessageHandler;
import com.google.checkout.handlers.NotificationAcknowledgment;
import com.google.checkout.notification.ChargeAmountNotification;

public class ChargeAmountNotificationHandler
implements MessageHandler {
    public String process(MerchantInfo mi, String notificationMsg) throws CheckoutException {
        try {
            ChargeAmountNotification notification = new ChargeAmountNotification(notificationMsg);
            String ack = this.getAckString();
            GoogleOrder order = GoogleOrder.findOrCreate(mi.getMerchantId(), notification.getGoogleOrderNumber());
            order.addIncomingMessage(notification.getTimestamp(), notification.getRootNodeName(), notification.getXmlPretty(), ack);
            return ack;
        }
        catch (Exception e) {
            throw new CheckoutException(e);
        }
    }

    private String getAckString() {
        return NotificationAcknowledgment.getAckString();
    }
}

