/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.checkout;

import com.google.checkout.checkout.USArea;
import com.google.checkout.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShippingRestrictions {
    private Document document = Utils.newEmptyDocument();
    private Element root = this.document.createElement("shipping-restrictions");

    public ShippingRestrictions() {
        this.document.appendChild(this.root);
    }

    public void addAllowedCountryArea(USArea countryArea) {
        Element allowedAreas = Utils.findContainerElseCreate(this.document, this.root, "allowed-areas");
        Element usCountry = Utils.createNewContainer(this.document, allowedAreas, "us-country-area");
        usCountry.setAttribute("country-area", countryArea.toString());
    }

    public void addAllowedStateCode(String stateCode) {
        Element allowedAreas = Utils.findContainerElseCreate(this.document, this.root, "allowed-areas");
        Element usState = Utils.createNewContainer(this.document, allowedAreas, "us-state-area");
        Utils.createNewElementAndSet(this.document, usState, "state", stateCode);
    }

    public void addAllowedZipPattern(String zipPattern) {
        Element allowedAreas = Utils.findContainerElseCreate(this.document, this.root, "allowed-areas");
        Element usZip = Utils.createNewContainer(this.document, allowedAreas, "us-zip-area");
        Utils.createNewElementAndSet(this.document, usZip, "zip-pattern", zipPattern);
    }

    public void addExcludedCountryArea(USArea countryArea) {
        Element excludedAreas = Utils.findContainerElseCreate(this.document, this.root, "excluded-areas");
        Element usCountry = Utils.createNewContainer(this.document, excludedAreas, "us-country-area");
        usCountry.setAttribute("country-area", countryArea.toString());
    }

    public void addExcludedStateCode(String stateCode) {
        Element excludedAreas = Utils.findContainerElseCreate(this.document, this.root, "excluded-areas");
        Element usState = Utils.createNewContainer(this.document, excludedAreas, "us-state-area");
        Utils.createNewElementAndSet(this.document, usState, "state", stateCode);
    }

    public void addExcludedZipPattern(String zipPattern) {
        Element excludedAreas = Utils.findContainerElseCreate(this.document, this.root, "excluded-areas");
        Element usZip = Utils.createNewContainer(this.document, excludedAreas, "us-zip-area");
        Utils.createNewElementAndSet(this.document, usZip, "zip-pattern", zipPattern);
    }

    public Element getRootElement() {
        return this.root;
    }

    public void addAllowedPostalArea(String countryCode, String postalCodePattern) {
        Element allowedAreas = Utils.findContainerElseCreate(this.document, this.root, "allowed-areas");
        Element pa = Utils.createNewContainer(this.document, allowedAreas, "postal-area");
        Utils.createNewElementAndSet(this.document, pa, "country-code", countryCode);
        Utils.createNewElementAndSet(this.document, pa, "postal-code-pattern", postalCodePattern);
    }

    public void addAllowedWorldArea() {
        Element allowedAreas = Utils.findContainerElseCreate(this.document, this.root, "allowed-areas");
        Utils.createNewContainer(this.document, allowedAreas, "world-area");
    }

    public void addExcludedPostalArea(String countryCode, String postalCodePattern) {
        Element excludedAreas = Utils.findContainerElseCreate(this.document, this.root, "excluded-areas");
        Element pa = Utils.createNewContainer(this.document, excludedAreas, "postal-area");
        Utils.createNewElementAndSet(this.document, pa, "country-code", countryCode);
        Utils.createNewElementAndSet(this.document, pa, "postal-code-pattern", postalCodePattern);
    }

    public void addExcludedWorldArea() {
        Element excludedAreas = Utils.findContainerElseCreate(this.document, this.root, "excluded-areas");
        Utils.createNewContainer(this.document, excludedAreas, "world-area");
    }

    public boolean isAllowUsPoBox() {
        return Utils.getElementBooleanValue(this.document, this.root, "allow-us-po-box");
    }

    public void setAllowUsPoBox(boolean b) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.root, "allow-us-po-box", b);
    }
}

