/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.checkout;

import com.google.checkout.checkout.DigitalContent;
import com.google.checkout.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Item {
    private final Document document;
    private final Element element;

    public Item(Document document, Element element) {
        this.document = document;
        this.element = element;
    }

    public Item() {
        this.document = Utils.newEmptyDocument();
        this.element = this.document.createElement("item");
        this.document.appendChild(this.element);
    }

    public String getItemDescription() {
        return Utils.getElementStringValue(this.document, this.element, "item-description");
    }

    public String getItemName() {
        return Utils.getElementStringValue(this.document, this.element, "item-name");
    }

    public String getMerchantItemId() {
        return Utils.getElementStringValue(this.document, this.element, "merchant-item-id");
    }

    public Element[] getMerchantPrivateItemData() {
        Element privateData = Utils.findElementOrContainer(this.document, this.element, "merchant-private-item-data");
        if (privateData == null) {
            return null;
        }
        return Utils.getElements(this.document, privateData);
    }

    public int getQuantity() {
        return Utils.getElementIntValue(this.document, this.element, "quantity");
    }

    public String getTaxTableSelector() {
        return Utils.getElementStringValue(this.document, this.element, "tax-table-selector");
    }

    public float getUnitPriceAmount() {
        return Utils.getElementFloatValue(this.document, this.element, "unit-price");
    }

    public String getUnitPriceCurrency() {
        Element unitPrice = Utils.findContainerElseCreate(this.document, this.element, "unit-price");
        return unitPrice.getAttribute("currency");
    }

    public float getItemWeight() {
        Element itemWeight = Utils.findElementOrContainer(this.document, this.element, "item-weight");
        if (itemWeight == null) {
            return -1.0f;
        }
        return Float.parseFloat(itemWeight.getAttribute("value"));
    }

    public String getItemWeightUnit() {
        Element itemWeight = Utils.findElementOrContainer(this.document, this.element, "item-weight");
        if (itemWeight == null) {
            return null;
        }
        return itemWeight.getAttribute("unit");
    }

    public void setItemDescription(String description) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "item-description", description);
    }

    public void setItemName(String itemName) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "item-name", itemName);
    }

    public void setMerchantItemId(String merchantItemId) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "merchant-item-id", merchantItemId);
    }

    public void setMerchantPrivateItemData(Element[] elements) {
        Element privateData = Utils.findElementOrContainer(this.document, this.element, "merchant-private-item-data");
        if (privateData != null) {
            this.element.removeChild(privateData);
        }
        privateData = this.document.createElement("merchant-private-item-data");
        Utils.importElements(this.document, privateData, elements);
        this.element.appendChild(privateData);
    }

    public void setQuantity(int quantity) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "quantity", quantity);
    }

    public void setTaxTableSelector(String taxTableSelector) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "tax-table-selector", taxTableSelector);
    }

    public void setUnitPriceAmount(float unitPriceAmount) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "unit-price", unitPriceAmount);
    }

    public void setUnitPriceCurrency(String unitPriceCurrencyCode) {
        Element unitPrice = Utils.findContainerElseCreate(this.document, this.element, "unit-price");
        unitPrice.setAttribute("currency", unitPriceCurrencyCode);
    }

    public void setItemWeight(float itemWeight) {
        Element unitPrice = Utils.findContainerElseCreate(this.document, this.element, "item-weight");
        unitPrice.setAttribute("value", Float.toString(itemWeight));
    }

    public void setItemWeightUnit(String itemWeightUnit) {
        Element unitPrice = Utils.findContainerElseCreate(this.document, this.element, "item-weight");
        unitPrice.setAttribute("unit", itemWeightUnit);
    }

    public DigitalContent getDigitalContent() {
        Element digitalContent = Utils.findElementOrContainer(this.document, this.element, "digital-content");
        if (digitalContent == null) {
            return null;
        }
        return new DigitalContent(this.document, digitalContent);
    }

    public void setDigitalContent(DigitalContent digitalContent) {
        Element dcElement = Utils.findElementOrContainer(this.document, this.element, "digital-content");
        if (dcElement != null) {
            this.element.removeChild(dcElement);
        }
        Utils.importElements(this.document, this.element, new Element[]{digitalContent.getRootElement()});
    }

    public Element getRootElement() {
        return this.element;
    }
}

