/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.checkout;

import com.google.checkout.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DigitalContent {
    private final Document document;
    private final Element element;

    public DigitalContent(Document document, Element element) {
        this.document = document;
        this.element = element;
    }

    public DigitalContent() {
        this.document = Utils.newEmptyDocument();
        this.element = this.document.createElement("digital-content");
        this.document.appendChild(this.element);
    }

    public boolean isEmailDelivery() {
        return Utils.getElementBooleanValue(this.document, this.element, "email-delivery");
    }

    public void setEmailDelivery(boolean emailDelivery) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "email-delivery", emailDelivery);
    }

    public String getDescription() {
        return Utils.getElementStringValue(this.document, this.element, "description");
    }

    public void setDescription(String description) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "description", description);
    }

    public String getKey() {
        return Utils.getElementStringValue(this.document, this.element, "key");
    }

    public void setKey(String key) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "key", key);
    }

    public String getUrl() {
        return Utils.getElementStringValue(this.document, this.element, "url");
    }

    public void setUrl(String url) {
        Utils.findElementAndSetElseCreateAndSet(this.document, this.element, "url", url);
    }

    public Element getRootElement() {
        return this.element;
    }
}

