/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout.checkout;

import com.google.checkout.AbstractCheckoutRequest;
import com.google.checkout.CheckoutException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.checkout.AddressFilters;
import com.google.checkout.checkout.CalculationMode;
import com.google.checkout.checkout.CarrierPickup;
import com.google.checkout.checkout.DeliveryAddressCategory;
import com.google.checkout.checkout.Item;
import com.google.checkout.checkout.Packaging;
import com.google.checkout.checkout.RoundingMode;
import com.google.checkout.checkout.RoundingRule;
import com.google.checkout.checkout.ShipFrom;
import com.google.checkout.checkout.ShippingRestrictions;
import com.google.checkout.checkout.TaxArea;
import com.google.checkout.checkout.UrlParameter;
import com.google.checkout.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CheckoutShoppingCartRequest
extends AbstractCheckoutRequest {
    private final Element shoppingCart;
    private final Element checkoutFlowSupport;

    public CheckoutShoppingCartRequest(MerchantInfo merchantInfo) {
        super(merchantInfo, "checkout-shopping-cart");
        Document document = this.getDocument();
        Element root = this.getRoot();
        this.shoppingCart = document.createElement("shopping-cart");
        this.checkoutFlowSupport = document.createElement("checkout-flow-support");
        Element merchantCheckoutFlowSupport = document.createElement("merchant-checkout-flow-support");
        root.appendChild(this.shoppingCart);
        root.appendChild(this.checkoutFlowSupport);
        this.checkoutFlowSupport.appendChild(merchantCheckoutFlowSupport);
    }

    public CheckoutShoppingCartRequest(MerchantInfo merchantInfo, String cartXml) throws CheckoutException {
        super(merchantInfo, Utils.newDocumentFromString(cartXml));
        Document document = this.getDocument();
        Element root = this.getRoot();
        this.shoppingCart = Utils.findContainerElseCreate(document, root, "shopping-cart");
        this.checkoutFlowSupport = Utils.findContainerElseCreate(document, root, "checkout-flow-support");
    }

    public CheckoutShoppingCartRequest(MerchantInfo merchantInfo, int expirationMinutesFromNow) {
        this(merchantInfo);
        this.setExpirationMinutesFromNow(expirationMinutesFromNow);
    }

    public void addFlatRateShippingMethod(String name, float cost, ShippingRestrictions restrictions) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element shippingMethods = Utils.findContainerElseCreate(document, mcfs, "shipping-methods");
        Element newShip = Utils.createNewContainer(document, shippingMethods, "flat-rate-shipping");
        newShip.setAttribute("name", name);
        Element price = Utils.createNewElementAndSet(document, newShip, "price", cost);
        price.setAttribute("currency", this.merchantInfo.getCurrencyCode());
        if (restrictions != null) {
            Utils.importElements(document, newShip, new Element[]{restrictions.getRootElement()});
        }
    }

    public void addItem(String name, String description, float price, int quantity) {
        this.addItem(name, description, price, quantity, null, null, null);
    }

    public void addItem(String name, String description, float price, int quantity, String merchantItemID) {
        this.addItem(name, description, price, quantity, merchantItemID, null, null);
    }

    public void addItem(String name, String description, float price, int quantity, Element[] merchantPrivateItemData) {
        this.addItem(name, description, price, quantity, null, merchantPrivateItemData, null);
    }

    public void addItem(String name, String description, float price, int quantity, String merchantItemID, Element[] merchantPrivateItemData, String taxTableSelector) {
        Document document = this.getDocument();
        Element items = Utils.findContainerElseCreate(document, this.shoppingCart, "items");
        Element item = Utils.createNewContainer(document, items, "item");
        Utils.createNewElementAndSet(document, item, "item-name", name);
        Utils.createNewElementAndSet(document, item, "item-description", description);
        Element ePrice = Utils.createNewElementAndSet(document, item, "unit-price", price);
        ePrice.setAttribute("currency", this.merchantInfo.getCurrencyCode());
        Utils.createNewElementAndSet(document, item, "quantity", quantity);
        if (merchantItemID != null) {
            Utils.createNewElementAndSet(document, item, "merchant-item-id", merchantItemID);
        }
        if (merchantPrivateItemData != null) {
            Element privateItemData = Utils.createNewContainer(document, item, "merchant-private-item-data");
            Utils.importElements(document, privateItemData, merchantPrivateItemData);
        }
        if (taxTableSelector != null) {
            Utils.createNewElementAndSet(document, item, "tax-table-selector", taxTableSelector);
        }
    }

    public void addItem(Item item) {
        Document document = this.getDocument();
        Element items = Utils.findContainerElseCreate(document, this.shoppingCart, "items");
        Utils.importElements(document, items, new Element[]{item.getRootElement()});
    }

    public void addMerchantCalculatedShippingMethod(String name, float defaultCost) {
        this.addMerchantCalculatedShippingMethod(name, defaultCost, null);
    }

    public void addMerchantCalculatedShippingMethod(String name, float defaultCost, ShippingRestrictions restrictions) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element shippingMethods = Utils.findContainerElseCreate(document, mcfs, "shipping-methods");
        Element newShip = Utils.createNewContainer(document, shippingMethods, "merchant-calculated-shipping");
        newShip.setAttribute("name", name);
        Element price = Utils.createNewElementAndSet(document, newShip, "price", defaultCost);
        price.setAttribute("currency", this.merchantInfo.getCurrencyCode());
        if (restrictions != null) {
            Utils.importElements(document, newShip, new Element[]{restrictions.getRootElement()});
        }
    }

    public void addMerchantCalculatedShippingMethod(String name, float defaultCost, ShippingRestrictions restrictions, AddressFilters filters) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element shippingMethods = Utils.findContainerElseCreate(document, mcfs, "shipping-methods");
        Element newShip = Utils.createNewContainer(document, shippingMethods, "merchant-calculated-shipping");
        newShip.setAttribute("name", name);
        Element price = Utils.createNewElementAndSet(document, newShip, "price", defaultCost);
        price.setAttribute("currency", this.merchantInfo.getCurrencyCode());
        if (restrictions != null) {
            Utils.importElements(document, newShip, new Element[]{restrictions.getRootElement()});
        }
        if (filters != null) {
            Utils.importElements(document, newShip, new Element[]{filters.getRootElement()});
        }
    }

    public void addPickupShippingMethod(String name, float cost) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element shippingMethods = Utils.findContainerElseCreate(document, mcfs, "shipping-methods");
        Element newShip = Utils.createNewContainer(document, shippingMethods, "pickup");
        newShip.setAttribute("name", name);
        Element price = Utils.createNewElementAndSet(document, newShip, "price", cost);
        price.setAttribute("currency", this.merchantInfo.getCurrencyCode());
    }

    public String getAnalyticsData() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return "";
        }
        return Utils.getElementStringValue(document, mcfs, "analytics-data");
    }

    public Date getCartExpiration() throws CheckoutException {
        Document document = this.getDocument();
        Element expiration = Utils.findElementOrContainer(document, this.shoppingCart, "cart-expiration");
        if (expiration == null) {
            return null;
        }
        Date goodUntilDate = Utils.getElementDateValue(document, expiration, "good-until-date");
        return goodUntilDate;
    }

    public String getContinueShoppingUrl() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return "";
        }
        return Utils.getElementStringValue(document, mcfs, "continue-shopping-url");
    }

    public String getEditCartUrl() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return "";
        }
        return Utils.getElementStringValue(document, mcfs, "edit-cart-url");
    }

    public String getMerchantCalculationsUrl() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return "";
        }
        Element merchantCalcs = Utils.findElementOrContainer(document, mcfs, "merchant-calculations");
        if (merchantCalcs == null) {
            return "";
        }
        return Utils.getElementStringValue(document, merchantCalcs, "merchant-calculations-url");
    }

    public long getPlatformID() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return 0L;
        }
        return Utils.getElementLongValue(document, mcfs, "platform-id");
    }

    public boolean isAcceptMerchantCoupons() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return false;
        }
        Element merchantCalcs = Utils.findElementOrContainer(document, mcfs, "merchant-calculations");
        if (merchantCalcs == null) {
            return false;
        }
        return Utils.getElementBooleanValue(document, merchantCalcs, "accept-merchant-coupons");
    }

    public boolean isAcceptMerchantGiftCertificates() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return false;
        }
        Element merchantCalcs = Utils.findElementOrContainer(document, mcfs, "merchant-calculations");
        if (merchantCalcs == null) {
            return false;
        }
        return Utils.getElementBooleanValue(document, merchantCalcs, "accept-gift-certificates");
    }

    public boolean isMerchantCalculatedTax() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return false;
        }
        Element taxTables = Utils.findContainerElseCreate(document, mcfs, "tax-tables");
        if (taxTables == null) {
            return false;
        }
        return Boolean.valueOf(taxTables.getAttribute("merchant-calculated"));
    }

    public boolean isRequestBuyerPhoneNumber() {
        Document document = this.getDocument();
        Element mcfs = Utils.findElementOrContainer(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        if (mcfs == null) {
            return false;
        }
        return Utils.getElementBooleanValue(document, mcfs, "request-buyer-phone-number");
    }

    public void setAcceptMerchantCoupons(boolean b) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element merchantCalcs = Utils.findContainerElseCreate(document, mcfs, "merchant-calculations");
        Utils.findElementAndSetElseCreateAndSet(document, merchantCalcs, "accept-merchant-coupons", b);
    }

    public void setAcceptMerchantGiftCertificates(boolean b) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element merchantCalcs = Utils.findContainerElseCreate(document, mcfs, "merchant-calculations");
        Utils.findElementAndSetElseCreateAndSet(document, merchantCalcs, "accept-gift-certificates", b);
    }

    public void setCalculationMode(CalculationMode calcMode) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element merchantCalcs = Utils.findContainerElseCreate(document, mcfs, "merchant-calculations");
        Utils.findElementAndSetElseCreateAndSet(document, merchantCalcs, "calculation-mode", calcMode.toString());
    }

    public void setAnalyticsData(String data) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Utils.findElementAndSetElseCreateAndSet(document, mcfs, "analytics-data", data);
    }

    public void setCartExpiration(Date date) {
        Document document = this.getDocument();
        Element expiration = Utils.findContainerElseCreate(document, this.shoppingCart, "cart-expiration");
        Utils.findElementAndSetElseCreateAndSet(document, expiration, "good-until-date", date);
    }

    public void setContinueShoppingUrl(String url) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Utils.findElementAndSetElseCreateAndSet(document, mcfs, "continue-shopping-url", url);
    }

    public void setEditCartUrl(String url) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Utils.findElementAndSetElseCreateAndSet(document, mcfs, "edit-cart-url", url);
    }

    public void setExpirationMinutesFromNow(int expirationMinutesFromNow) {
        Calendar cal = Calendar.getInstance();
        cal.add(12, expirationMinutesFromNow);
        this.setCartExpiration(cal.getTime());
    }

    public void setMerchantCalculatedTax(boolean b) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element taxTables = Utils.findContainerElseCreate(document, mcfs, "tax-tables");
        taxTables.setAttribute("merchant-calculated", "" + b);
    }

    public void setMerchantCalculationsUrl(String url) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element merchantCalcs = Utils.findContainerElseCreate(document, mcfs, "merchant-calculations");
        Utils.findElementAndSetElseCreateAndSet(document, merchantCalcs, "merchant-calculations-url", url);
    }

    public void setPlatformID(long platformId) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Utils.findElementAndSetElseCreateAndSet(document, mcfs, "platform-id", platformId);
    }

    public void setRequestBuyerPhoneNumber(boolean b) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Utils.findElementAndSetElseCreateAndSet(document, mcfs, "request-buyer-phone-number", b);
    }

    public Element[] getMerchantPrivateDataNodes() {
        Document document = this.getDocument();
        Element mpd = Utils.findElementOrContainer(document, this.shoppingCart, "merchant-private-data");
        if (mpd == null) {
            return null;
        }
        return Utils.getElements(document, mpd);
    }

    public void setMerchantPrivateDataNodes(Element[] nodes) {
        Document document = this.getDocument();
        Element mpd = Utils.findContainerElseCreate(document, this.shoppingCart, "merchant-private-data");
        Utils.importElements(document, mpd, nodes);
    }

    public void addAlternateTaxRule(String tableName, boolean standalone, double taxRate, TaxArea taxArea) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element taxTables = Utils.findContainerElseCreate(document, mcfs, "tax-tables");
        Element alternateTaxTables = Utils.findContainerElseCreate(document, taxTables, "alternate-tax-tables");
        Element newTaxTable = Utils.findContainerWithAttributeValueElseCreate(document, alternateTaxTables, "alternate-tax-table", "name", tableName);
        newTaxTable.setAttribute("standalone", "" + standalone);
        Element alternateTaxRules = Utils.findContainerElseCreate(document, newTaxTable, "alternate-tax-rules");
        Element newRule = Utils.createNewContainer(document, alternateTaxRules, "alternate-tax-rule");
        Utils.createNewElementAndSet(document, newRule, "rate", taxRate);
        Utils.importElements(document, newRule, new Element[]{taxArea.getRootElement()});
    }

    public void addDefaultTaxRule(double taxRate, boolean shippingTaxed, TaxArea taxArea) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element taxTables = Utils.findContainerElseCreate(document, mcfs, "tax-tables");
        Element defaultTaxTable = Utils.findContainerElseCreate(document, taxTables, "default-tax-table");
        Element taxRules = Utils.findContainerElseCreate(document, defaultTaxTable, "tax-rules");
        Element newRule = Utils.createNewContainer(document, taxRules, "default-tax-rule");
        Utils.createNewElementAndSet(document, newRule, "shipping-taxed", shippingTaxed);
        Utils.createNewElementAndSet(document, newRule, "rate", taxRate);
        Utils.importElements(document, newRule, new Element[]{taxArea.getRootElement()});
    }

    public void addParameterizedUrl(String url) throws UnsupportedEncodingException {
        this.addParameterizedUrl(url, false);
    }

    public void addParameterizedUrl(String url, boolean urlEncode) throws UnsupportedEncodingException {
        this.addParameterizedUrl(url, urlEncode, null);
    }

    public void addParameterizedUrl(String url, Collection parameters) throws UnsupportedEncodingException {
        this.addParameterizedUrl(url, false, parameters);
    }

    public void addParameterizedUrl(String url, boolean urlEncode, Collection parameters) throws UnsupportedEncodingException {
        if (urlEncode) {
            url = URLEncoder.encode(url, "UTF-8");
        }
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element pUrls = Utils.findContainerElseCreate(document, mcfs, "parameterized-urls");
        Element pUrl = Utils.createNewContainer(document, pUrls, "parameterized-url");
        pUrl.setAttribute("url", url);
        if (parameters != null) {
            Element eParams = Utils.createNewContainer(document, pUrl, "parameters");
            for (UrlParameter param : parameters) {
                Element eParam = Utils.createNewContainer(document, eParams, "url-parameter");
                eParam.setAttribute("name", param.getName());
                eParam.setAttribute("type", param.getParamType().toString());
            }
        }
    }

    public String getPostUrl() {
        return this.merchantInfo.getMerchantCheckoutUrl();
    }

    public void addFlatRateShippingMethod(String name, float cost) {
        this.addFlatRateShippingMethod(name, cost, null);
    }

    public void addMerchantPrivateDataNode(Element node) {
        Document document = this.getDocument();
        Element mpd = Utils.findContainerElseCreate(document, this.shoppingCart, "merchant-private-data");
        Utils.importElements(document, mpd, new Element[]{node});
    }

    public boolean isRequestInitialAuthDetails() {
        Element root;
        Document document = this.getDocument();
        Element ops = Utils.findElementOrContainer(document, root = this.getRoot(), "order-processing-support");
        if (ops == null) {
            return false;
        }
        return Utils.getElementBooleanValue(document, ops, "request-initial-auth-details");
    }

    public void setRequestInitialAuthDetails(boolean b) {
        Document document = this.getDocument();
        Element root = this.getRoot();
        Element ops = Utils.findContainerElseCreate(document, root, "order-processing-support");
        Utils.findElementAndSetElseCreateAndSet(document, ops, "request-initial-auth-details", b);
    }

    public void setRoundingPolicy(RoundingRule rule, RoundingMode mode) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element policy = Utils.findContainerElseCreate(document, mcfs, "rounding-policy");
        Utils.findElementAndSetElseCreateAndSet(document, policy, "rule", rule.toString());
        Utils.findElementAndSetElseCreateAndSet(document, policy, "mode", mode.toString());
    }

    public void addCarrierCalculatedShippingOption(float price, String shippingCompany, CarrierPickup carrierPickup, String shippingType, float additionalFixedCharge, float additionalVariableChargePercent) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element shippingMethods = Utils.findContainerElseCreate(document, mcfs, "shipping-methods");
        Element ccShip = Utils.findContainerElseCreate(document, shippingMethods, "carrier-calculated-shipping");
        Element ccShipOps = Utils.findContainerElseCreate(document, ccShip, "carrier-calculated-shipping-options");
        Element newShip = Utils.createNewContainer(document, ccShipOps, "carrier-calculated-shipping-option");
        Element priceElement = Utils.createNewElementAndSet(document, newShip, "price", price);
        priceElement.setAttribute("currency", this.merchantInfo.getCurrencyCode());
        Utils.createNewElementAndSet(document, newShip, "shipping-company", shippingCompany);
        if (carrierPickup != null) {
            Utils.createNewElementAndSet(document, newShip, "carrier-pickup", carrierPickup.toString());
        }
        Utils.createNewElementAndSet(document, newShip, "shipping-type", shippingType);
        Element fixedCharge = Utils.createNewElementAndSet(document, newShip, "additional-fixed-charge", additionalFixedCharge);
        fixedCharge.setAttribute("currency", this.merchantInfo.getCurrencyCode());
        Utils.createNewElementAndSet(document, newShip, "additional-variable-charge-percent", additionalVariableChargePercent);
    }

    public void addShippingPackage(DeliveryAddressCategory deliveryAddressCategory, String heightUnit, float heightValue, String widthUnit, float widthValue, String lengthUnit, float lengthValue, Packaging packaging, ShipFrom shipFrom) {
        Document document = this.getDocument();
        Element mcfs = Utils.findContainerElseCreate(document, this.checkoutFlowSupport, "merchant-checkout-flow-support");
        Element shippingMethods = Utils.findContainerElseCreate(document, mcfs, "shipping-methods");
        Element ccShip = Utils.findContainerElseCreate(document, shippingMethods, "carrier-calculated-shipping");
        Element shipPackages = Utils.findContainerElseCreate(document, ccShip, "shipping-packages");
        Element newPack = Utils.createNewContainer(document, shipPackages, "shipping-package");
        if (deliveryAddressCategory != null) {
            Utils.createNewElementAndSet(document, newPack, "delivery-address-category", deliveryAddressCategory.toString());
        }
        Element height = Utils.createNewContainer(document, newPack, "height");
        height.setAttribute("unit", heightUnit);
        height.setAttribute("value", "" + heightValue);
        Element length = Utils.createNewContainer(document, newPack, "length");
        length.setAttribute("unit", lengthUnit);
        length.setAttribute("value", "" + lengthValue);
        Element width = Utils.createNewContainer(document, newPack, "width");
        width.setAttribute("unit", widthUnit);
        width.setAttribute("value", "" + widthValue);
        if (packaging != null) {
            Utils.createNewElementAndSet(document, newPack, "packaging", packaging.toString());
        }
        Utils.importElements(document, newPack, new Element[]{shipFrom.getRootElement()});
    }
}

