/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout;

import com.google.checkout.util.Utils;
import java.io.Serializable;
import java.util.Date;

public class Message
implements Serializable {
    private boolean incoming;
    private Date timestamp;
    private String type;
    private String request;
    private String response;

    public Message(boolean incoming, Date timestamp, String type, String request, String response) {
        this.incoming = incoming;
        this.timestamp = timestamp;
        this.type = type;
        this.request = request;
        this.response = response;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHeader() {
        String ret = Utils.getDateString(this.getTimestamp()).replace('T', ' ') + " : " + this.type;
        return ret;
    }

    public String getBody() {
        StringBuffer sb = new StringBuffer();
        if (this.incoming) {
            sb.append("You Received:\n\n");
            sb.append(this.request + "\n");
            sb.append("You Sent:\n\n");
            sb.append(this.response + "\n");
        } else {
            sb.append("You Sent:\n\n");
            sb.append(this.request + "\n");
            sb.append("You Received:\n\n");
            sb.append(this.response + "\n");
        }
        return sb.toString();
    }
}

