/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout;

import com.google.checkout.CheckoutException;
import com.google.checkout.CheckoutSystemException;
import com.google.checkout.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class GoogleOrder
implements Serializable {
    private String merchantId;
    private String orderNumber;
    private String lastFinStatus;
    private String lastFulStatus;
    private Date lastUpdateTime;
    private String buyerEmail;
    private String orderAmount;
    private Collection events = new ArrayList();
    static String dir = System.getProperty("java.io.tmpdir");
    static File fDir = new File(dir);

    public static GoogleOrder findOrCreate(String merchantId, String orderNumber) throws CheckoutException {
        String fileName = "GCO_" + merchantId + "_" + orderNumber + ".ser";
        File file = new File(fDir, fileName);
        if (file.exists()) {
            return GoogleOrder.readFromFile(file);
        }
        GoogleOrder ret = new GoogleOrder(merchantId, orderNumber);
        return ret;
    }

    public static GoogleOrder readFromFile(File file) throws CheckoutException {
        String fileName = file.getName();
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            GoogleOrder ret = (GoogleOrder)in.readObject();
            in.close();
            return ret;
        }
        catch (FileNotFoundException ex) {
            throw new CheckoutException("Could not find file " + fileName);
        }
        catch (IOException ex) {
            throw new CheckoutException("Encountered the following error when attemptingto read file " + fileName + ": " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new CheckoutException("Encountered the following error when attemptingto read file " + fileName + ": " + ex.getMessage());
        }
    }

    public static GoogleOrder[] findAll(String merchantId) throws CheckoutException {
        File[] files = fDir.listFiles(new OrderFilter(merchantId));
        GoogleOrder[] ret = new GoogleOrder[files.length];
        for (int i = 0; i < files.length; ++i) {
            ret[i] = GoogleOrder.readFromFile(files[i]);
        }
        return ret;
    }

    public String getBuyerEmail() {
        return this.buyerEmail;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public String getLastFinStatus() {
        return this.lastFinStatus;
    }

    public void setLastFinStatus(String lastFinStatus) {
        this.lastFinStatus = lastFinStatus;
    }

    public String getLastFulStatus() {
        return this.lastFulStatus;
    }

    public void setLastFulStatus(String lastFulStatus) {
        this.lastFulStatus = lastFulStatus;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public Collection getEvents() {
        return this.events;
    }

    public void setNotifications(Collection events) {
        this.events = events;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public GoogleOrder(String merchantId, String orderNumber) {
        this.merchantId = merchantId;
        this.orderNumber = orderNumber;
    }

    public synchronized void addIncomingMessage(Date timestamp, String type, String request, String response) throws CheckoutException {
        this.lastUpdateTime = timestamp;
        this.events.add(new Message(true, timestamp, type, request, response));
        this.save();
    }

    public synchronized void addOutgoingMessage(Date timestamp, String type, String request, String response) throws CheckoutException {
        this.events.add(new Message(false, timestamp, type, request, response));
        this.save();
    }

    private void save() throws CheckoutException {
        String fileName = "GCO_" + this.merchantId + "_" + this.orderNumber + ".ser";
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(dir, fileName)));
            out.writeObject(this);
            out.close();
        }
        catch (FileNotFoundException ex) {
            throw new CheckoutException("Could not find file " + fileName);
        }
        catch (IOException ex) {
            throw new CheckoutSystemException("Encountered the following error when attemptingto save file " + fileName + ": " + ex.getMessage());
        }
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
    }

    public static class OrderFilter
    implements FilenameFilter {
        String mid;

        public OrderFilter(String mid) {
            this.mid = mid;
        }

        public boolean accept(File file, String name) {
            return name.startsWith("GCO_" + this.mid);
        }
    }
}

