/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout;

import com.google.checkout.CheckoutException;
import com.google.checkout.util.Utils;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CheckoutResponse {
    private final Document document;
    private final Element root;

    public CheckoutResponse() throws CheckoutException {
        this("");
    }

    public CheckoutResponse(String response) throws CheckoutException {
        this.document = Utils.newDocumentFromString(response);
        this.root = this.document.getDocumentElement();
    }

    public CheckoutResponse(InputStream response) throws CheckoutException {
        this.document = Utils.newDocumentFromInputStream(response);
        this.root = this.document.getDocumentElement();
    }

    public boolean isValidRequest() {
        String nodeName = this.root.getNodeName();
        return "checkout-redirect".equals(nodeName) || "request-received".equals(nodeName);
    }

    public String getSerialNumber() {
        return this.root.getAttribute("serial-number");
    }

    public String getErrorMessage() {
        return Utils.getElementStringValue(this.document, this.root, "error-message");
    }

    public String getRedirectUrl() {
        return Utils.getElementStringValue(this.document, this.root, "redirect-url");
    }

    public String getXml() {
        return Utils.documentToString(this.document);
    }

    public String getXmlPretty() {
        return Utils.documentToStringPretty(this.document);
    }
}

