/*
 * Decompiled with CFR 0.152.
 */
package com.google.checkout;

import com.google.checkout.CheckoutException;
import com.google.checkout.CheckoutResponse;
import com.google.checkout.CheckoutSystemException;
import com.google.checkout.MerchantInfo;
import com.google.checkout.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractCheckoutRequest {
    protected MerchantInfo merchantInfo;
    private final Document document;
    private final Element root;

    public AbstractCheckoutRequest(MerchantInfo merchantInfo, String requestType) {
        if (merchantInfo == null) {
            throw new IllegalArgumentException("MerchantInfo cannot be null");
        }
        this.merchantInfo = merchantInfo;
        this.document = Utils.newEmptyDocument();
        this.root = this.document.createElementNS("http://checkout.google.com/schema/2", requestType);
        this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://checkout.google.com/schema/2");
        this.document.appendChild(this.root);
    }

    public AbstractCheckoutRequest(MerchantInfo merchantInfo, Document document) {
        this.merchantInfo = merchantInfo;
        this.document = document;
        this.root = document.getDocumentElement();
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Element getRoot() {
        return this.root;
    }

    public String getPostUrl() {
        return this.merchantInfo.getRequestUrl();
    }

    public String getXml() {
        return Utils.documentToString(this.document);
    }

    public String getXmlPretty() {
        return Utils.documentToStringPretty(this.document);
    }

    public CheckoutResponse send() throws CheckoutException {
        try {
            URL url = new URL(this.getPostUrl());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Basic " + this.merchantInfo.getHttpAuth());
            connection.setRequestProperty("Host", connection.getURL().getHost());
            connection.setRequestProperty("content-type", "application/xml; charset=UTF-8");
            connection.setRequestProperty("accept", "application/xml");
            PrintWriter output = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF8"));
            output.print(this.getXml());
            output.flush();
            output.close();
            int responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode == 200 ? connection.getInputStream() : connection.getErrorStream();
            return new CheckoutResponse(inputStream);
        }
        catch (MalformedURLException ex) {
            throw new CheckoutException("MalformedURLException encountered.  URL was: " + this.getPostUrl(), ex);
        }
        catch (IOException ex) {
            throw new CheckoutSystemException("IOException encountered.");
        }
    }
}

