/*
 * Decompiled with CFR 0.152.
 */
package jdbm.strings;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.extser.DataInput;
import jdbm.extser.DataOutput;
import jdbm.extser.IStreamSerializer;
import jdbm.extser.Stateless;
import jdbm.helper.IntegerComparator;
import jdbm.helper.IntegerSerializer;
import jdbm.helper.StringComparator;
import jdbm.helper.StringSerializer;
import jdbm.helper.compression.LeadingValueCompressionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTable
implements Externalizable {
    transient RecordManager _recman;
    transient long _recid;
    long m_internId;
    long m_disinternId;
    private transient BTree<String, Integer> m_internBTree = null;
    private transient BTree<Integer, String> m_disinternBTree = null;
    public static final int NULLID = -1;
    private static final long serialVersionUID = 5509848259406652128L;

    public long getRecid() {
        return this._recid;
    }

    public static StringTable createInstance(RecordManager recman) throws IOException {
        StringTable stbl = new StringTable();
        stbl._recman = recman;
        stbl.getInternBTree(recman);
        stbl.getDisinternBTree(recman);
        stbl._recid = recman.insert(stbl);
        return stbl;
    }

    public static StringTable load(RecordManager recman, long recid) throws IOException {
        StringTable stbl = (StringTable)recman.fetch(recid);
        if (stbl == null) {
            throw new IllegalArgumentException("No such record: " + recid);
        }
        stbl._recman = recman;
        stbl._recid = recid;
        return stbl;
    }

    public synchronized int intern(String s, boolean insert) throws IOException {
        if (s == null) {
            return -1;
        }
        BTree<String, Integer> internBTree = this.getInternBTree(this._recman);
        Integer stringId = internBTree.find(s);
        if (stringId == null) {
            if (!insert) {
                return 0;
            }
            BTree<Integer, String> disinternBTree = this.getDisinternBTree(this._recman);
            long nstrings = disinternBTree.entryCount();
            if (nstrings + 1L >= Integer.MAX_VALUE) {
                throw new RuntimeException("Too many interned strings");
            }
            stringId = new Integer((int)(nstrings + 1L));
            Object oldValue = disinternBTree.insert(stringId, s, false);
            if (oldValue != null) {
                throw new AssertionError((Object)("Already used: stringId=" + stringId));
            }
            oldValue = internBTree.insert(s, stringId, false);
            if (oldValue != null) {
                throw new AssertionError((Object)("Already interned: " + s));
            }
        }
        return stringId;
    }

    public synchronized String disintern(int stringId) throws IOException {
        if (stringId == -1) {
            return null;
        }
        BTree<Integer, String> disinternBTree = this.getDisinternBTree(this._recman);
        String s = disinternBTree.find(new Integer(stringId));
        if (s == null) {
            throw new IllegalArgumentException("Invalid stringId=" + stringId);
        }
        return s;
    }

    private synchronized BTree<String, Integer> getInternBTree(RecordManager recman) throws IOException {
        if (this.m_internBTree == null) {
            if (this.m_internId != 0L) {
                this.m_internBTree = BTree.load(recman, this.m_internId);
            } else {
                this.m_internBTree = BTree.createInstance(recman, new StringComparator(), StringSerializer.INSTANCE, IntegerSerializer.INSTANCE);
                this.m_internBTree.setKeyCompressionProvider(LeadingValueCompressionProvider.STRING);
                this.m_internId = this.m_internBTree.getRecid();
            }
        }
        return this.m_internBTree;
    }

    private synchronized BTree<Integer, String> getDisinternBTree(RecordManager recman) throws IOException {
        if (this.m_disinternBTree == null) {
            if (this.m_disinternId != 0L) {
                this.m_disinternBTree = BTree.load(recman, this.m_disinternId);
            } else {
                this.m_disinternBTree = BTree.createInstance(recman, new IntegerComparator(), IntegerSerializer.INSTANCE, StringSerializer.INSTANCE);
                this.m_disinternId = this.m_disinternBTree.getRecid();
            }
        }
        return this.m_disinternBTree;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.m_internId);
        out.writeLong(this.m_disinternId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_internId = in.readLong();
        this.m_disinternId = in.readLong();
    }

    public static class Serializer0
    implements IStreamSerializer,
    Stateless {
        private static final long serialVersionUID = 5530442158408957105L;

        public void serialize(DataOutput out, Object obj) throws IOException {
            StringTable tmp = (StringTable)obj;
            out.writePackedLong(tmp.m_internId);
            out.writePackedLong(tmp.m_disinternId);
        }

        public Object deserialize(DataInput in, Object obj) throws IOException {
            StringTable tmp = (StringTable)obj;
            tmp.m_internId = in.readPackedLong();
            tmp.m_disinternId = in.readPackedLong();
            return tmp;
        }
    }
}

