/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jdbm.recman.BlockView;

public final class BlockIo
implements Externalizable {
    public static final long serialVersionUID = 2L;
    private long blockId;
    private transient byte[] data;
    private transient BlockView view = null;
    private transient boolean dirty = false;
    private transient int transactionCount = 0;

    public BlockIo() {
    }

    BlockIo(long blockId, byte[] data) {
        this.blockId = blockId;
        this.data = data;
    }

    byte[] getData() {
        return this.data;
    }

    void setBlockId(long id) {
        if (this.isInTransaction()) {
            throw new Error("BlockId assigned for transaction block");
        }
        this.blockId = id;
    }

    long getBlockId() {
        return this.blockId;
    }

    public BlockView getView() {
        return this.view;
    }

    public void setView(BlockView view) {
        this.view = view;
    }

    void setDirty() {
        this.dirty = true;
    }

    void setClean() {
        this.dirty = false;
    }

    boolean isDirty() {
        return this.dirty;
    }

    boolean isInTransaction() {
        return this.transactionCount != 0;
    }

    synchronized void incrementTransactionCount() {
        ++this.transactionCount;
        this.setClean();
    }

    synchronized void decrementTransactionCount() {
        --this.transactionCount;
        if (this.transactionCount < 0) {
            throw new Error("transaction count on block " + this.getBlockId() + " below zero!");
        }
    }

    public byte readByte(int pos) {
        return this.data[pos];
    }

    public void writeByte(int pos, byte value) {
        this.data[pos] = value;
        this.setDirty();
    }

    public short readShort(int pos) {
        return (short)((short)(this.data[pos + 0] & 0xFF) << 8 | (short)(this.data[pos + 1] & 0xFF) << 0);
    }

    public void writeShort(int pos, short value) {
        this.data[pos + 0] = (byte)(0xFF & value >> 8);
        this.data[pos + 1] = (byte)(0xFF & value >> 0);
        this.setDirty();
    }

    public int readInt(int pos) {
        return (this.data[pos + 0] & 0xFF) << 24 | (this.data[pos + 1] & 0xFF) << 16 | (this.data[pos + 2] & 0xFF) << 8 | (this.data[pos + 3] & 0xFF) << 0;
    }

    public void writeInt(int pos, int value) {
        this.data[pos + 0] = (byte)(0xFF & value >> 24);
        this.data[pos + 1] = (byte)(0xFF & value >> 16);
        this.data[pos + 2] = (byte)(0xFF & value >> 8);
        this.data[pos + 3] = (byte)(0xFF & value >> 0);
        this.setDirty();
    }

    public long readLong(int pos) {
        return (long)(this.data[pos + 0] & 0xFF) << 56 | (long)(this.data[pos + 1] & 0xFF) << 48 | (long)(this.data[pos + 2] & 0xFF) << 40 | (long)(this.data[pos + 3] & 0xFF) << 32 | (long)(this.data[pos + 4] & 0xFF) << 24 | (long)(this.data[pos + 5] & 0xFF) << 16 | (long)(this.data[pos + 6] & 0xFF) << 8 | (long)(this.data[pos + 7] & 0xFF) << 0;
    }

    public void writeLong(int pos, long value) {
        this.data[pos + 0] = (byte)(0xFFL & value >> 56);
        this.data[pos + 1] = (byte)(0xFFL & value >> 48);
        this.data[pos + 2] = (byte)(0xFFL & value >> 40);
        this.data[pos + 3] = (byte)(0xFFL & value >> 32);
        this.data[pos + 4] = (byte)(0xFFL & value >> 24);
        this.data[pos + 5] = (byte)(0xFFL & value >> 16);
        this.data[pos + 6] = (byte)(0xFFL & value >> 8);
        this.data[pos + 7] = (byte)(0xFFL & value >> 0);
        this.setDirty();
    }

    public String toString() {
        return "BlockIO(" + this.blockId + "," + this.dirty + "," + this.view + ")";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.blockId = in.readLong();
        int length = in.readInt();
        this.data = new byte[length];
        in.readFully(this.data);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.blockId);
        out.writeInt(this.data.length);
        out.write(this.data);
    }
}

