/*
 * Decompiled with CFR 0.152.
 */
package jdbm.extser;

import java.io.IOException;
import java.lang.reflect.Array;
import jdbm.extser.DataInput;
import jdbm.extser.DataOutput;

public class NativeType {
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int CHAR = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;
    public static final int BOOLEAN_ARRAY = 9;
    public static final int BYTE_ARRAY = 10;
    public static final int CHAR_ARRAY = 11;
    public static final int SHORT_ARRAY = 12;
    public static final int INT_ARRAY = 13;
    public static final int LONG_ARRAY = 14;
    public static final int FLOAT_ARRAY = 15;
    public static final int DOUBLE_ARRAY = 16;
    public static final int OBJECT_ARRAY = 17;
    public static final int FIRST_OBJECT_INDEX = 18;

    public static final boolean isJavaObject(int classId) {
        return classId >= 18;
    }

    public static final boolean isNull(int classId) {
        return classId == 0;
    }

    public static final boolean isPrimitive(int classId) {
        return classId >= 1 && classId <= 8;
    }

    public static final boolean isPrimitiveArrayType(int classId) {
        return classId >= 9 && classId <= 16;
    }

    public static final boolean isArrayType(int classId) {
        return classId >= 9 && classId <= 17;
    }

    public static String asString(int classId) {
        switch (classId) {
            case 0: {
                return "null";
            }
            case 1: {
                return Boolean.class.getName();
            }
            case 2: {
                return Byte.class.getName();
            }
            case 3: {
                return Character.class.getName();
            }
            case 4: {
                return Short.class.getName();
            }
            case 5: {
                return Integer.class.getName();
            }
            case 6: {
                return Long.class.getName();
            }
            case 7: {
                return Float.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 9: {
                return "boolean[]";
            }
            case 10: {
                return "byte[]";
            }
            case 11: {
                return "char[]";
            }
            case 12: {
                return "short[]";
            }
            case 13: {
                return "int[]";
            }
            case 14: {
                return "long[]";
            }
            case 15: {
                return "float[]";
            }
            case 16: {
                return "double[]";
            }
            case 17: {
                return "Object[]";
            }
        }
        return "Object<" + classId + ">";
    }

    public static int getNativeType(Object val) {
        if (val == null) {
            return 0;
        }
        if (val instanceof Boolean) {
            return 1;
        }
        if (val instanceof Character) {
            return 3;
        }
        if (val instanceof Number) {
            if (val instanceof Byte) {
                return 2;
            }
            if (val instanceof Short) {
                return 4;
            }
            if (val instanceof Integer) {
                return 5;
            }
            if (val instanceof Long) {
                return 6;
            }
            if (val instanceof Float) {
                return 7;
            }
            if (val instanceof Double) {
                return 8;
            }
            return 18;
        }
        if (val.getClass().isArray()) {
            if (val.getClass().getComponentType().isPrimitive()) {
                Class<?> componentType = val.getClass().getComponentType();
                if (componentType.equals(Boolean.TYPE)) {
                    return 9;
                }
                if (componentType.equals(Byte.TYPE)) {
                    return 10;
                }
                if (componentType.equals(Character.TYPE)) {
                    return 11;
                }
                if (componentType.equals(Short.TYPE)) {
                    return 12;
                }
                if (componentType.equals(Integer.TYPE)) {
                    return 13;
                }
                if (componentType.equals(Long.TYPE)) {
                    return 14;
                }
                if (componentType.equals(Float.TYPE)) {
                    return 15;
                }
                if (componentType.equals(Double.TYPE)) {
                    return 16;
                }
                throw new AssertionError();
            }
            return 17;
        }
        return 18;
    }

    public static void serialize(DataOutput dos, int classId, Object obj) throws IOException {
        switch (classId) {
            case 0: {
                return;
            }
            case 1: {
                dos.writeBoolean((Boolean)obj);
                return;
            }
            case 2: {
                dos.writeByte(((Byte)obj).byteValue());
                return;
            }
            case 3: {
                dos.writeChar(((Character)obj).charValue());
                return;
            }
            case 4: {
                dos.writeShort(((Short)obj).shortValue());
                return;
            }
            case 5: {
                dos.writeInt((Integer)obj);
                return;
            }
            case 6: {
                dos.writeLong((Long)obj);
                return;
            }
            case 7: {
                dos.writeFloat(((Float)obj).floatValue());
                return;
            }
            case 8: {
                dos.writeDouble((Double)obj);
                return;
            }
            case 9: {
                boolean[] ary = (boolean[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeBoolean(ary[i]);
                }
                return;
            }
            case 10: {
                byte[] ary = (byte[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeByte(ary[i]);
                }
                return;
            }
            case 11: {
                char[] ary = (char[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeChar(ary[i]);
                }
                return;
            }
            case 12: {
                short[] ary = (short[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeShort(ary[i]);
                }
                return;
            }
            case 13: {
                int[] ary = (int[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeInt(ary[i]);
                }
                return;
            }
            case 14: {
                long[] ary = (long[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeLong(ary[i]);
                }
                return;
            }
            case 15: {
                float[] ary = (float[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeFloat(ary[i]);
                }
                return;
            }
            case 16: {
                double[] ary = (double[])obj;
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.writeDouble(ary[i]);
                }
                return;
            }
            case 17: {
                Object[] ary = (Object[])obj;
                Class<?> componentType = ary.getClass().getComponentType();
                int componentTypeId = dos.getSerializationHandler().getClassId(componentType);
                dos.writePackedInt(componentTypeId);
                int len = ary.length;
                dos.writePackedInt(len);
                for (int i = 0; i < len; ++i) {
                    dos.serialize(ary[i]);
                }
                return;
            }
        }
        throw new AssertionError((Object)("classId=" + classId));
    }

    public static Object deserialize(DataInput dis, int classId, short versionId) throws IOException {
        switch (classId) {
            case 0: {
                return null;
            }
            case 1: {
                if (dis.readBoolean()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 2: {
                return new Byte(dis.readByte());
            }
            case 3: {
                return new Character(dis.readChar());
            }
            case 4: {
                return new Short(dis.readShort());
            }
            case 5: {
                return new Integer(dis.readInt());
            }
            case 6: {
                return new Long(dis.readLong());
            }
            case 7: {
                return new Float(dis.readFloat());
            }
            case 8: {
                return new Double(dis.readDouble());
            }
            case 9: {
                int len = dis.readPackedInt();
                boolean[] ary = new boolean[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readBoolean();
                }
                return ary;
            }
            case 10: {
                int len = dis.readPackedInt();
                byte[] ary = new byte[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readByte();
                }
                return ary;
            }
            case 11: {
                int len = dis.readPackedInt();
                char[] ary = new char[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readChar();
                }
                return ary;
            }
            case 12: {
                int len = dis.readPackedInt();
                short[] ary = new short[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readShort();
                }
                return ary;
            }
            case 13: {
                int len = dis.readPackedInt();
                int[] ary = new int[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readInt();
                }
                return ary;
            }
            case 14: {
                int len = dis.readPackedInt();
                long[] ary = new long[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readLong();
                }
                return ary;
            }
            case 15: {
                int len = dis.readPackedInt();
                float[] ary = new float[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readFloat();
                }
                return ary;
            }
            case 16: {
                int len = dis.readPackedInt();
                double[] ary = new double[len];
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.readDouble();
                }
                return ary;
            }
            case 17: {
                int componentTypeId = dis.readPackedInt();
                Class componentType = dis.getSerializationHandler().getClass(componentTypeId);
                int len = dis.readPackedInt();
                Object[] ary = (Object[])Array.newInstance(componentType, len);
                for (int i = 0; i < len; ++i) {
                    ary[i] = dis.deserialize();
                }
                return ary;
            }
        }
        throw new AssertionError((Object)("classId=" + classId));
    }
}

