/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper.ui;

import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.call.FetchTokenCall;
import com.ebay.sdk.call.GetSessionIDCall;
import com.ebay.sdk.helper.ui.BrowserLauncher;
import com.ebay.sdk.helper.ui.DialogAccount;
import com.ebay.sdk.helper.ui.DialogFetchToken_btnFetchToken_actionAdapter;
import com.ebay.sdk.helper.ui.DialogFetchToken_btnGetSessionID_actionAdapter;
import com.ebay.sdk.helper.ui.DialogFetchToken_btnLaunchWebBrowser_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class DialogFetchToken
extends JDialog {
    private ApiContext apiContext = null;
    private String generatedToken = null;
    private boolean closeOnToken = false;
    private boolean cancelled = true;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanelSecret = new JPanel();
    JPanel jPanel5 = new JPanel();
    JTextField txtSessionID = new JTextField();
    JButton btnFetchToken = new JButton();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextPane txtToken = new JTextPane();
    JPanel jPanel7 = new JPanel();
    JLabel jLabel2 = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanelRuName = new JPanel();
    JPanel jPanel9 = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel10 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel11 = new JPanel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel1 = new JLabel();
    JButton btnGetSessionID = new JButton();
    JLabel jLabel4 = new JLabel();
    BorderLayout borderLayout7 = new BorderLayout();
    BorderLayout borderLayout8 = new BorderLayout();
    BorderLayout borderLayout9 = new BorderLayout();
    JPanel jPanel12 = new JPanel();
    JLabel jLabel10 = new JLabel();
    JTextField ruNameField = new JTextField();
    JPanel jPanel13 = new JPanel();
    BorderLayout borderLayout10 = new BorderLayout();
    JLabel jLabel5 = new JLabel();
    BorderLayout borderLayout11 = new BorderLayout();
    JPanel jPanel14 = new JPanel();
    JPanel jPanel15 = new JPanel();
    BorderLayout borderLayout12 = new BorderLayout();
    JLabel jLabel6 = new JLabel();
    JButton btnLaunchWebBrowser = new JButton();

    public void setCloseOnToken(boolean closeOnToken) {
        this.closeOnToken = closeOnToken;
    }

    public String getGeneratedToken() {
        return this.generatedToken;
    }

    public boolean isCloseOnToken() {
        return this.closeOnToken;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public DialogFetchToken(Frame frame, ApiContext apiContext, String title, boolean modal) {
        super(frame, title, modal);
        try {
            String signInUrl;
            this.jbInit();
            this.pack();
            this.apiContext = apiContext;
            if (this.apiContext == null) {
                throw new Exception("DialogFetchToken: ApiContext is not specified.");
            }
            if (this.apiContext.getRuName() != null) {
                this.ruNameField.setText(this.apiContext.getRuName());
            }
            if ((signInUrl = this.apiContext.getSignInUrl()) == null || signInUrl.length() == 0) {
                throw new Exception("SignIn Url must be specified to call FetchToken.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.txtSessionID.setPreferredSize(new Dimension(160, 21));
        this.txtSessionID.setEditable(false);
        this.txtSessionID.setText("");
        this.btnFetchToken.setText("FetchToken");
        this.btnFetchToken.addActionListener(new DialogFetchToken_btnFetchToken_actionAdapter(this));
        this.jPanelSecret.setLayout(this.borderLayout6);
        this.jPanel2.setLayout(this.borderLayout3);
        this.txtToken.setEditable(false);
        this.txtToken.setText("");
        this.jLabel2.setText("API Token");
        this.jScrollPane1.setPreferredSize(new Dimension(400, 100));
        this.jPanel3.setLayout(this.borderLayout4);
        this.jPanelRuName.setLayout(this.borderLayout5);
        this.jLabel3.setText("2) Retrieve a Session ID.");
        this.jLabel1.setText("Session ID:");
        this.btnGetSessionID.setText("GetSessionID");
        this.btnGetSessionID.addActionListener(new DialogFetchToken_btnGetSessionID_actionAdapter(this));
        this.jLabel4.setText("1) Please input your RuName here.");
        this.jPanel6.setLayout(this.borderLayout8);
        this.jPanel4.setLayout(this.borderLayout9);
        this.jPanel13.setLayout(this.borderLayout10);
        this.jLabel5.setText("4) Click FetchToken API to retrieve the generated token text.");
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel9.setLayout(this.borderLayout11);
        this.jPanel14.setLayout(this.borderLayout12);
        this.jLabel6.setText("3) Launch web browser with your secret and sign-in to generate the token online.");
        this.btnLaunchWebBrowser.setText("Launch Web Browser");
        this.btnLaunchWebBrowser.addActionListener(new DialogFetchToken_btnLaunchWebBrowser_actionAdapter(this));
        this.jPanel11.add((Component)this.jLabel1, null);
        this.jPanel11.add((Component)this.txtSessionID, null);
        this.jPanel11.add((Component)this.btnGetSessionID, null);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanelSecret, "Center");
        this.jPanelSecret.add((Component)this.jPanel6, "North");
        this.jPanel1.add((Component)this.jPanelRuName, "North");
        this.jPanel1.add((Component)this.jPanel9, "South");
        this.jPanel9.add((Component)this.jPanel14, "North");
        this.jPanel14.add((Component)this.jLabel6, "West");
        this.jPanel9.add((Component)this.jPanel15, "Center");
        this.jPanel15.add((Component)this.btnLaunchWebBrowser, null);
        this.panel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.btnFetchToken, null);
        this.jPanel2.add((Component)this.jPanel13, "North");
        this.jPanel13.add((Component)this.jLabel5, "West");
        this.panel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jPanel7, "North");
        this.jPanel7.add((Component)this.jLabel2, null);
        this.jScrollPane1.getViewport().add((Component)this.txtToken, null);
        this.jPanelRuName.add((Component)this.jPanel4, "North");
        this.jPanelRuName.add((Component)this.jPanel10, "South");
        this.jPanelRuName.add((Component)this.jPanel12, "Center");
        this.jPanelSecret.add((Component)this.jPanel11, "Center");
        this.jPanel6.add((Component)this.jLabel3, "Center");
        this.jPanel4.add((Component)this.jLabel4, "Center");
        this.jLabel10.setText("RuName :");
        this.jPanel12.add(this.jLabel10);
        this.jPanel12.add(this.ruNameField);
        this.ruNameField.setPreferredSize(new Dimension(160, 21));
    }

    private boolean validateApiAccount() {
        ApiAccount acc = this.apiContext.getApiCredential().getApiAccount();
        if (acc == null) {
            return false;
        }
        if (acc.getDeveloper().length() == 0) {
            return false;
        }
        if (acc.getApplication().length() == 0) {
            return false;
        }
        return acc.getCertificate().length() != 0;
    }

    void btnFetchToken_actionPerformed(ActionEvent e) {
        try {
            FetchTokenCall api = new FetchTokenCall(this.apiContext);
            String s = this.txtSessionID.getText();
            if (s.length() == 0) {
                throw new SdkException("Please get SessionID first.");
            }
            api.setSessionID(s);
            this.generatedToken = api.fetchToken();
            this.txtToken.setText(this.generatedToken);
            if (this.closeOnToken) {
                DialogAccount.showInfoMessage(this, "The API token has been generated successfully!");
                this.cancelled = false;
                this.dispose();
            }
        }
        catch (Exception ex) {
            String msg = ex.getClass().getName() + " : " + ex.getMessage();
            DialogAccount.showErrorMessage(this, msg);
        }
    }

    void getSessionID() {
        try {
            if (!this.validateApiAccount()) {
                throw new SdkException("Please fill in Api Account first.");
            }
            GetSessionIDCall api = new GetSessionIDCall(this.apiContext);
            String runame = this.getRuName();
            if (runame == null || runame.length() == 0) {
                throw new Exception("Please select a RuName.");
            }
            api.setRuName(runame);
            String s = api.getSessionID();
            this.txtSessionID.setText(s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DialogAccount.showErrorMessage(this, ex.getMessage());
        }
    }

    private String getRuName() {
        String ruName = this.ruNameField.getText();
        if (ruName.length() == 0) {
            return null;
        }
        return ruName;
    }

    void btnGetSessionID_actionPerformed(ActionEvent e) {
        this.getSessionID();
    }

    void btnLaunchWebBrowser_actionPerformed(ActionEvent e) {
        try {
            String sessionID = this.txtSessionID.getText();
            if (sessionID.length() == 0) {
                throw new Exception("Please get SessionID first.");
            }
            String runame = this.getRuName();
            if (runame == null || runame.length() == 0) {
                throw new Exception("Please select a RuName.");
            }
            String signInUrl = this.apiContext.getSignInUrl();
            String url = MessageFormat.format("{0}&sessid={1}&runame={2}", signInUrl, sessionID, runame);
            BrowserLauncher.openURL(url);
        }
        catch (Exception ex) {
            DialogAccount.showErrorMessage(this, ex.getMessage());
        }
    }
}

