/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper.ui;

import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.helper.ui.DialogAccount_btnCancel_actionAdapter;
import com.ebay.sdk.helper.ui.DialogAccount_btnFetchToken_actionAdapter;
import com.ebay.sdk.helper.ui.DialogAccount_btnOK_actionAdapter;
import com.ebay.sdk.helper.ui.DialogAccount_txtDeveloperID_actionAdapter;
import com.ebay.sdk.helper.ui.DialogFetchToken;
import com.ebay.sdk.helper.ui.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class DialogAccount
extends JDialog {
    public static final String TITLE = "eBay SDK for Java";
    private ApiContext _apiContext;
    private boolean cancelled = true;
    private boolean enableApiCredentials = true;
    BorderLayout borderLayout1 = new BorderLayout();
    JButton btnOK = new JButton();
    JPanel jPanelBottom = new JPanel();
    JPanel jPanelUNCredential = new JPanel();
    JPanel jPanelTokenCredential = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanelAPIAccount = new JPanel();
    JPanel jPanelUNCHolder = new JPanel();
    JPanel jPanelTCHolder = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanelDevId = new JPanel();
    JPanel jPanelCertificate = new JPanel();
    JTextField txtDeveloperID = new JTextField();
    JLabel jLabel1 = new JLabel();
    JTextField txtCertificate = new JTextField();
    JLabel jLabel3 = new JLabel();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel10 = new JPanel();
    JPanel jPanel11 = new JPanel();
    JLabel jLabel6 = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    BorderLayout borderLayout8 = new BorderLayout();
    JPanel jPanel12 = new JPanel();
    JPanel jPanel13 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    JPanel jPanelApiServer = new JPanel();
    JPanel jPanelEpsServer = new JPanel();
    JTextField txtApiServerUrl = new JTextField();
    JLabel jLabel9 = new JLabel();
    JTextField txtEpsServerUrl = new JTextField();
    JLabel jLabel10 = new JLabel();
    ButtonGroup CredentialType = new ButtonGroup();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextPane txtTokenData = new JTextPane();
    JPanel jPanel16 = new JPanel();
    BorderLayout borderLayout9 = new BorderLayout();
    JPanel jPanelApiCredentials = new JPanel();
    JLabel jLabel2 = new JLabel();
    JTextField txtApplicationID = new JTextField();
    JPanel jPanelAppId = new JPanel();
    JPanel jPanelSignInUrl = new JPanel();
    JTextField txtSigninUrl = new JTextField();
    JLabel jLabel11 = new JLabel();
    JButton btnCancel = new JButton();
    JPanel jPanelChoices = new JPanel();
    BorderLayout borderLayout10 = new BorderLayout();
    JButton btnFetchToken = new JButton();

    public String getSignInUrl() {
        return this.txtSigninUrl.getText();
    }

    public void setSignInUrl(String url) {
        this.txtSigninUrl.setText(url);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public ApiContext getApiContext() {
        return this._apiContext;
    }

    public DialogAccount(Frame frame, ApiContext apiContext, String title, boolean modal, boolean enableApiCredentials) {
        super(frame, title, modal);
        this.enableApiCredentials = enableApiCredentials;
        try {
            this.jbInit();
            this.pack();
            this._apiContext = apiContext;
            this.populateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void populateUI() {
        this.txtTokenData.setText(this._apiContext.getApiCredential().geteBayToken());
        ApiAccount ac = this._apiContext.getApiCredential().getApiAccount();
        if (this.enableApiCredentials) {
            this.txtDeveloperID.setText(ac.getDeveloper());
            this.txtApplicationID.setText(ac.getApplication());
            this.txtCertificate.setText(ac.getCertificate());
        } else {
            this.txtDeveloperID.setEnabled(false);
            this.txtApplicationID.setEnabled(false);
            this.txtCertificate.setEnabled(false);
        }
        this.txtApiServerUrl.setText(this._apiContext.getApiServerUrl());
        this.txtEpsServerUrl.setText(this._apiContext.getEpsServerUrl());
        this.txtSigninUrl.setText(this._apiContext.getSignInUrl());
    }

    public DialogAccount(Frame frame, ApiContext apiContext, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this._apiContext = apiContext;
            this.populateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.setModal(true);
        this.setResizable(true);
        this.setTitle("API Account Settings");
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new DialogAccount_btnOK_actionAdapter(this));
        this.jPanelUNCredential.setDebugGraphicsOptions(0);
        this.jPanelUNCredential.setLayout(this.borderLayout2);
        this.jPanelTokenCredential.setLayout(this.borderLayout3);
        this.jPanel1.setLayout(this.borderLayout5);
        this.jPanelUNCHolder.setLayout(this.borderLayout6);
        this.jPanelTCHolder.setLayout(this.borderLayout7);
        this.jPanelAPIAccount.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(3);
        this.jLabel1.setPreferredSize(new Dimension(80, 15));
        this.jLabel1.setText("DeveloperID:");
        this.jLabel3.setPreferredSize(new Dimension(80, 15));
        this.jLabel3.setText("Certificate:");
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.jLabel6.setText("Paste your token text or ");
        this.jPanel10.setLayout(this.borderLayout4);
        this.jLabel7.setText("        ");
        this.jLabel8.setToolTipText("");
        this.jLabel8.setText("        ");
        this.txtDeveloperID.setPreferredSize(new Dimension(120, 21));
        this.txtDeveloperID.setSelectionStart(10);
        this.txtDeveloperID.setText("");
        this.txtDeveloperID.addActionListener(new DialogAccount_txtDeveloperID_actionAdapter(this));
        this.txtCertificate.setPreferredSize(new Dimension(120, 21));
        this.txtCertificate.setText("");
        this.jPanelBottom.setLayout(this.borderLayout8);
        this.jPanel13.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(3);
        this.jLabel9.setPreferredSize(new Dimension(90, 15));
        this.jLabel9.setText("API Server URL:");
        this.jLabel10.setPreferredSize(new Dimension(90, 15));
        this.jLabel10.setText("EPS Server URL:");
        this.txtApiServerUrl.setPreferredSize(new Dimension(280, 21));
        this.txtApiServerUrl.setText("");
        this.txtEpsServerUrl.setPreferredSize(new Dimension(280, 21));
        this.txtEpsServerUrl.setText("http://msa-e1.ebay.com/ws/eBayISAPI.dll?EpsBasicApp");
        this.txtEpsServerUrl.setColumns(0);
        this.jPanel16.setLayout(this.borderLayout9);
        this.jLabel2.setPreferredSize(new Dimension(80, 15));
        this.jLabel2.setText("ApplicationID:");
        this.txtApplicationID.setPreferredSize(new Dimension(120, 21));
        this.txtApplicationID.setRequestFocusEnabled(true);
        this.txtApplicationID.setText("");
        this.txtTokenData.setPreferredSize(new Dimension(50, 200));
        this.txtSigninUrl.setPreferredSize(new Dimension(280, 21));
        this.txtSigninUrl.setText("http://my.sandbox.ebay.com/ws/eBayISAPI.dll?SignIn");
        this.jLabel11.setPreferredSize(new Dimension(90, 15));
        this.jLabel11.setText("Sign-In URL:");
        this.jPanel13.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setPreferredSize(new Dimension(54, 40));
        this.btnCancel.setToolTipText("");
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new DialogAccount_btnCancel_actionAdapter(this));
        this.jPanelChoices.setLayout(this.borderLayout10);
        this.btnFetchToken.setText("Generate a New Token");
        this.btnFetchToken.addActionListener(new DialogAccount_btnFetchToken_actionAdapter(this));
        this.jPanel10.setPreferredSize(new Dimension(102, 40));
        this.jPanel16.setPreferredSize(new Dimension(400, 480));
        this.jPanelTokenCredential.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelApiCredentials.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelAppId.add((Component)this.jLabel2, null);
        this.jPanelAppId.add((Component)this.txtApplicationID, null);
        this.getContentPane().add((Component)this.jPanelBottom, "South");
        this.jPanel10.add((Component)this.jLabel7, "West");
        this.jPanel10.add((Component)this.jLabel8, "East");
        this.jPanel10.add((Component)this.jScrollPane1, "Center");
        this.jPanel16.add((Component)this.jPanel13, "South");
        this.jScrollPane1.getViewport().add((Component)this.txtTokenData, null);
        this.jPanelTokenCredential.add((Component)this.jPanel11, "North");
        this.jPanel11.add((Component)this.jLabel6, null);
        this.jPanel11.add((Component)this.btnFetchToken, null);
        this.jPanelTokenCredential.add((Component)this.jPanel10, "Center");
        this.jPanelTCHolder.add((Component)this.jPanelTokenCredential, "Center");
        this.getContentPane().add((Component)this.jPanel16, "Center");
        this.jPanelDevId.add((Component)this.jLabel1, null);
        this.jPanelDevId.add((Component)this.txtDeveloperID, null);
        this.jPanelAPIAccount.add((Component)this.jPanelDevId, null);
        this.jPanelCertificate.add((Component)this.jLabel3, null);
        this.jPanelCertificate.add((Component)this.txtCertificate, null);
        this.jPanel16.add((Component)this.jPanelChoices, "Center");
        this.jPanelChoices.add((Component)this.jPanelUNCHolder, "North");
        this.jPanelAPIAccount.add((Component)this.jPanelAppId, null);
        this.jPanelAPIAccount.add((Component)this.jPanelCertificate, null);
        this.jPanelUNCHolder.add((Component)this.jPanelUNCredential, "Center");
        this.jPanel16.add((Component)this.jPanelApiCredentials, "North");
        this.jPanelApiCredentials.add((Component)this.jPanelAPIAccount, null);
        this.jPanelUNCredential.add((Component)this.jPanel1, "South");
        this.jPanelChoices.add((Component)this.jPanelTCHolder, "Center");
        this.jPanelBottom.add((Component)this.jPanel12, "South");
        this.jPanel12.add((Component)this.btnOK, null);
        this.jPanel12.add((Component)this.btnCancel, null);
        this.jPanelApiServer.add((Component)this.jLabel9, null);
        this.jPanelApiServer.add((Component)this.txtApiServerUrl, null);
        this.jPanel13.add((Component)this.jPanelEpsServer, null);
        this.jPanel13.add((Component)this.jPanelApiServer, null);
        this.jPanelEpsServer.add((Component)this.jLabel10, null);
        this.jPanelEpsServer.add((Component)this.txtEpsServerUrl, null);
        this.jPanel13.add((Component)this.jPanelSignInUrl, null);
        this.jPanelSignInUrl.add((Component)this.jLabel11, null);
        this.jPanelSignInUrl.add((Component)this.txtSigninUrl, null);
    }

    public static void showErrorMessage(Component parent, String error) {
        JOptionPane.showMessageDialog(parent, error, TITLE, 0);
    }

    public static void showInfoMessage(Component parent, String error) {
        JOptionPane.showMessageDialog(parent, error, TITLE, 1);
    }

    void parseApiContextFromGUI(boolean needToken) throws Exception {
        String s;
        if (this.enableApiCredentials) {
            ApiAccount ac = this._apiContext.getApiCredential().getApiAccount();
            ac.setApplication(this.txtApplicationID.getText());
            ac.setDeveloper(this.txtDeveloperID.getText());
            ac.setCertificate(this.txtCertificate.getText());
        }
        if ((s = this.txtTokenData.getText()).length() == 0 && needToken) {
            throw new Exception("Please enter the API token.");
        }
        this._apiContext.getApiCredential().seteBayToken(s);
        this._apiContext.setApiServerUrl(this.txtApiServerUrl.getText());
        this._apiContext.setEpsServerUrl(this.txtEpsServerUrl.getText());
        this._apiContext.setSignInUrl(this.txtSigninUrl.getText());
    }

    void btnOK_actionPerformed(ActionEvent e) {
        try {
            this.parseApiContextFromGUI(true);
            this.cancelled = false;
            this.dispose();
        }
        catch (Exception ex) {
            DialogAccount.showErrorMessage(this, ex.getMessage());
        }
    }

    void txtDeveloperID_actionPerformed(ActionEvent e) {
    }

    void btnCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void btnFetchToken_actionPerformed(ActionEvent e) {
        try {
            this.parseApiContextFromGUI(false);
            DialogFetchToken dlg = new DialogFetchToken(null, this._apiContext, "Acquire eBay API Token - Java FetchToken", true);
            dlg.setCloseOnToken(true);
            GuiUtil.CenterComponent(dlg);
            dlg.setVisible(true);
            if (!dlg.isCancelled()) {
                this.txtTokenData.setText(dlg.getGeneratedToken());
            }
        }
        catch (Exception ex) {
            DialogAccount.showErrorMessage(this, ex.getMessage());
        }
    }
}

