/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper;

import com.ebay.sdk.helper.InternationalShippingServiceSelector;
import com.ebay.sdk.helper.PaymentServiceHelper;
import com.ebay.sdk.helper.RegionServiceHelper;
import com.ebay.sdk.helper.ShippingServiceHelper;
import com.ebay.sdk.helper.ShippingServiceSelector;
import com.ebay.sdk.helper.ui.ControlTagItem;
import com.ebay.sdk.helper.ui.JIDCheckBox;
import com.ebay.soap.eBLBaseComponents.AmountType;
import com.ebay.soap.eBLBaseComponents.BuyerPaymentMethodCodeType;
import com.ebay.soap.eBLBaseComponents.CurrencyCodeType;
import com.ebay.soap.eBLBaseComponents.InternationalShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.ShippingDetailsType;
import com.ebay.soap.eBLBaseComponents.ShippingServiceCodeType;
import com.ebay.soap.eBLBaseComponents.ShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.ShippingTypeCodeType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ServiceControlManager {
    static ServiceControlManager _serviceControlManager = new ServiceControlManager();

    private ServiceControlManager() {
    }

    public static ServiceControlManager getInstance() {
        return _serviceControlManager;
    }

    public ControlTagItem[] createPaymentServiceControl(SiteCodeType siteId, boolean addDefaultOption) {
        Hashtable map = PaymentServiceHelper.getInstance().getPaymentServiceMap(siteId);
        int size = map.size();
        int addition = addDefaultOption ? 1 : 0;
        ControlTagItem[] ctrlServices = new ControlTagItem[size + addition];
        if (addDefaultOption) {
            ctrlServices[0] = new ControlTagItem("None", "None");
        }
        Enumeration keys = map.keys();
        int cnt = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            ctrlServices[addition + cnt++] = (ControlTagItem)map.get(key);
        }
        return ctrlServices;
    }

    public ControlTagItem[] createPaymentServiceControl(SiteCodeType site, JComboBox cbxControl, boolean addDefaultOption) {
        ControlTagItem[] ctrlServices = this.createPaymentServiceControl(site, addDefaultOption);
        DefaultComboBoxModel<ControlTagItem> dataModel = new DefaultComboBoxModel<ControlTagItem>(ctrlServices);
        cbxControl.setModel(dataModel);
        cbxControl.setSelectedIndex(0);
        return ctrlServices;
    }

    public ControlTagItem[] createRegionServiceControl(SiteCodeType siteId, boolean addDefaultOption) {
        Hashtable map = RegionServiceHelper.getInstanace().getRegionsMap(siteId);
        int size = map.size();
        int addition = addDefaultOption ? 1 : 0;
        ControlTagItem[] ctrlServices = new ControlTagItem[size + addition];
        if (addDefaultOption) {
            ctrlServices[0] = new ControlTagItem("None", "None");
        }
        Enumeration keys = map.keys();
        int cnt = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            ctrlServices[addition + cnt++] = (ControlTagItem)map.get(key);
        }
        return ctrlServices;
    }

    public ControlTagItem[] createShippingServiceControl(SiteCodeType siteId, String shippingType, boolean addDefaultOption) {
        Hashtable map = null;
        map = ShippingServiceHelper.FLAT_SHIPPING_METHODS.equals(shippingType) ? ShippingServiceHelper.getInstance().getDomesticShippingServiceMap(siteId, ShippingTypeCodeType.FLAT) : (ShippingServiceHelper.CALCULATED_SHIPPING_METHODS.equals(shippingType) ? ShippingServiceHelper.getInstance().getDomesticShippingServiceMap(siteId, ShippingTypeCodeType.CALCULATED) : (ShippingServiceHelper.INTL_FLATRATE_SHIPPING_SERVICES.equals(shippingType) ? ShippingServiceHelper.getInstance().getInternalShippingServiceMap(siteId, ShippingTypeCodeType.FLAT) : ShippingServiceHelper.getInstance().getInternalShippingServiceMap(siteId, ShippingTypeCodeType.CALCULATED)));
        int size = map.size();
        int addition = addDefaultOption ? 1 : 0;
        ControlTagItem[] ctrlServices = new ControlTagItem[size + addition];
        ctrlServices[0] = new ControlTagItem("None", "None");
        Enumeration keys = map.keys();
        int cnt = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            ctrlServices[addition + cnt++] = (ControlTagItem)map.get(key);
        }
        return ctrlServices;
    }

    public ControlTagItem[] createShippingServiceControl(SiteCodeType site, String shippingType, JComboBox cbxControl, boolean addDefaultOption) {
        ControlTagItem[] ctrlServices = this.createShippingServiceControl(site, shippingType, addDefaultOption);
        DefaultComboBoxModel<ControlTagItem> dataModel = new DefaultComboBoxModel<ControlTagItem>(ctrlServices);
        cbxControl.setModel(dataModel);
        cbxControl.setSelectedIndex(0);
        return ctrlServices;
    }

    public BuyerPaymentMethodCodeType[] processUserPaymentMethods(JCheckBox[] ckbPaymentServices, ControlTagItem[] ctrlPaymentServices) {
        BuyerPaymentMethodCodeType[] arrPaymentMethods = null;
        int cnt = ckbPaymentServices.length;
        if (cnt > 0) {
            int i;
            ArrayList<Object> lstPayments = new ArrayList<Object>();
            for (i = 0; i < cnt; ++i) {
                if (!ckbPaymentServices[i].isSelected()) continue;
                lstPayments.add(ctrlPaymentServices[i].Tag);
            }
            cnt = lstPayments.size();
            if (cnt > 0) {
                arrPaymentMethods = new BuyerPaymentMethodCodeType[cnt];
                for (i = 0; i < cnt; ++i) {
                    arrPaymentMethods[i] = (BuyerPaymentMethodCodeType)lstPayments.get(i);
                }
            }
        }
        return arrPaymentMethods;
    }

    public ShippingServiceOptionsType processUserSelectedShippingService(CurrencyCodeType currencyId, JComboBox cbxShippingServiceSelected, ControlTagItem[] ctrlShippingServices, JComboBox cbxIntlShippingServiceSelected, ControlTagItem[] ctrlIntlShippingServices, JTextField txtShippingServiceSelectedCost) {
        ShippingServiceOptionsType shippingServiceOptionsType = null;
        ShippingServiceCodeType selectedShippingService = null;
        int idx = cbxShippingServiceSelected.getSelectedIndex();
        if (idx > 0) {
            selectedShippingService = (ShippingServiceCodeType)ctrlShippingServices[idx].Tag;
        } else {
            idx = cbxIntlShippingServiceSelected.getSelectedIndex();
            if (idx > 0) {
                selectedShippingService = (ShippingServiceCodeType)ctrlIntlShippingServices[idx].Tag;
            }
        }
        if (selectedShippingService != null) {
            shippingServiceOptionsType = new ShippingServiceOptionsType();
            shippingServiceOptionsType.setShippingService(selectedShippingService.value());
            String cost = txtShippingServiceSelectedCost.getText();
            if (cost != null && cost.length() > 0) {
                AmountType shippingServiceSelectedCost = new AmountType();
                shippingServiceSelectedCost.setValue(Double.parseDouble(cost));
                shippingServiceSelectedCost.setCurrencyID(currencyId);
                shippingServiceOptionsType.setShippingServiceCost(shippingServiceSelectedCost);
            }
        }
        return shippingServiceOptionsType;
    }

    public ShippingDetailsType processUserShippingDetails(ArrayList shippingServiceOptions, ArrayList intlShippingServiceOptions) {
        int i;
        ShippingServiceOptionsType[] sso;
        ShippingDetailsType shippingDetails = new ShippingDetailsType();
        int cnt = shippingServiceOptions.size();
        if (cnt > 0) {
            sso = new ShippingServiceOptionsType[cnt];
            for (i = 0; i < cnt; ++i) {
                sso[i] = ((ShippingServiceSelector)shippingServiceOptions.get(i)).getSelectedShippingServiceOption();
            }
            shippingDetails.setShippingServiceOptions(sso);
        }
        if ((cnt = intlShippingServiceOptions.size()) > 0) {
            sso = new InternationalShippingServiceOptionsType[cnt];
            for (i = 0; i < cnt; ++i) {
                sso[i] = ((InternationalShippingServiceSelector)intlShippingServiceOptions.get(i)).getSelectedShippingServiceOption();
            }
            shippingDetails.setInternationalShippingServiceOption((InternationalShippingServiceOptionsType[])sso);
        }
        return shippingDetails;
    }

    String stringArrayToString(String[] strArray, String separator) {
        int cnt;
        String ret = null;
        int n = cnt = strArray != null ? strArray.length : 0;
        if (cnt > 0) {
            ret = strArray[0];
            for (int j = 1; j < cnt; ++j) {
                ret = ret + separator + strArray[j];
            }
        }
        return ret;
    }

    public ArrayList getSelectedCheckBoxList(JCheckBox[] checkBoxes) {
        ArrayList<String> list = new ArrayList<String>();
        int cnt = checkBoxes != null ? checkBoxes.length : 0;
        for (int i = 0; i < cnt; ++i) {
            JCheckBox chkBox = checkBoxes[i];
            if (!chkBox.isSelected()) continue;
            if (chkBox instanceof JIDCheckBox) {
                list.add(((JIDCheckBox)chkBox).getId());
                continue;
            }
            list.add(chkBox.getText());
        }
        return list;
    }

    public void updateShippingServiceSelections(ArrayList shippingServiceOptions, JScrollPane spShippingServiceOptions, JButton btnRemoveShippingService, JButton btnAddShippingService) {
        Object[] columnNames = new String[]{"Priority", "ShippingService", "Cost", "AdditionalCost"};
        int size = shippingServiceOptions.size();
        Object[][] dataTable = new Object[size][4];
        for (int i = 0; i < size; ++i) {
            ShippingServiceSelector selector = (ShippingServiceSelector)shippingServiceOptions.get(i);
            ShippingServiceOptionsType ssot = selector.getSelectedShippingServiceOption();
            dataTable[i][0] = new Integer(i + 1).toString();
            dataTable[i][1] = ssot.getShippingService().toString();
            AmountType cost = ssot.getShippingServiceCost();
            String sCost = " ";
            if (cost != null) {
                sCost = cost.getValue() + "";
            }
            dataTable[i][2] = sCost;
            cost = ssot.getShippingServiceAdditionalCost();
            sCost = cost != null ? cost.getValue() + "" : " ";
            dataTable[i][3] = sCost;
        }
        JTable jTable = new JTable(dataTable, columnNames);
        jTable.setEnabled(false);
        spShippingServiceOptions.getViewport().add((Component)jTable, null);
        if (btnRemoveShippingService != null) {
            btnRemoveShippingService.setEnabled(size > 0);
        }
        if (btnAddShippingService != null) {
            btnAddShippingService.setEnabled(size < 3);
        }
    }

    public void updateIntlShippingServiceSelections(ArrayList intlShippingServiceOptions, JScrollPane spIntlShippingServiceOptions, JButton btnRemoveIntlShippingService, JButton btnAddIntlShippingService) {
        Object[] columnNames = new String[]{"Priority", "ShippingService", "Cost", "AdditionalCost", "ShipToLocations"};
        int size = intlShippingServiceOptions.size();
        Object[][] dataTable = new Object[size][5];
        for (int i = 0; i < size; ++i) {
            int cnt;
            InternationalShippingServiceSelector selector = (InternationalShippingServiceSelector)intlShippingServiceOptions.get(i);
            InternationalShippingServiceOptionsType sso = selector.getSelectedShippingServiceOption();
            dataTable[i][0] = new Integer(i + 1).toString();
            dataTable[i][1] = sso.getShippingService().toString();
            AmountType cost = sso.getShippingServiceCost();
            String sCost = " ";
            if (cost != null) {
                sCost = cost.getValue() + "";
            }
            dataTable[i][2] = sCost;
            cost = sso.getShippingServiceAdditionalCost();
            sCost = cost != null ? cost.getValue() + "" : " ";
            dataTable[i][3] = sCost;
            String sShipToLocations = "";
            String[] arrShipToLocations = sso.getShipToLocation();
            int n = cnt = arrShipToLocations != null ? arrShipToLocations.length : 0;
            if (cnt > 0) {
                sShipToLocations = arrShipToLocations[0];
                for (int j = 1; j < cnt; ++j) {
                    sShipToLocations = sShipToLocations + ";" + arrShipToLocations[j];
                }
            }
            dataTable[i][4] = sShipToLocations;
        }
        JTable jTable = new JTable(dataTable, columnNames);
        jTable.setEnabled(false);
        spIntlShippingServiceOptions.getViewport().add((Component)jTable, null);
        if (btnRemoveIntlShippingService != null) {
            btnRemoveIntlShippingService.setEnabled(size > 0);
        }
        if (btnAddIntlShippingService != null) {
            btnAddIntlShippingService.setEnabled(size < 3);
        }
    }
}

