/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XHTMLSerializer;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.owasp.validator.css.CssScanner;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Tag;
import org.owasp.validator.html.util.ErrorMessageUtil;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AntiSamyDOMScanner {
    private Policy policy;
    private CleanResults results = null;
    private ArrayList errorMessages = new ArrayList();
    private Document document = new DocumentImpl();
    private DocumentFragment dom = this.document.createDocumentFragment();
    public static final String DEFAULT_ENCODING_ALGORITHM = "UTF-8";

    public CleanResults scan(String string, String string2, String string3) throws ScanException {
        if (string == null) {
            throw new ScanException("No input (null)");
        }
        int n = this.policy.getMaxInputSize();
        if (n < string.length()) {
            throw new ScanException(ErrorMessageUtil.getMessage("error.size.toolarge", new Object[]{new Integer(string.length()), new Integer(n)}));
        }
        Date date = new Date();
        try {
            Object object;
            Object object2;
            string = this.stripNonValidXMLCharacters(string);
            DOMFragmentParser dOMFragmentParser = new DOMFragmentParser();
            dOMFragmentParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            dOMFragmentParser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)string2);
            try {
                dOMFragmentParser.parse(new InputSource(new StringReader(string)), this.dom);
            }
            catch (Exception exception) {
                throw new ScanException(exception);
            }
            for (int i = 0; i < this.dom.getChildNodes().getLength(); ++i) {
                object2 = this.dom.getChildNodes().item(i);
                this.recursiveValidateTag((Node)object2);
                if (object2.getParentNode() != null) continue;
                --i;
            }
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setEncoding(string3);
            outputFormat.setOmitXMLDeclaration("true".equals(this.policy.getDirective("omitXmlDeclaration")));
            outputFormat.setOmitDocumentType("true".equals(this.policy.getDirective("omitDoctypeDeclaration")));
            outputFormat.setPreserveEmptyAttributes(true);
            if ("true".equals(this.policy.getDirective("formatOutput"))) {
                outputFormat.setLineWidth(80);
                outputFormat.setIndenting(true);
                outputFormat.setIndent(2);
            }
            object2 = new StringWriter();
            if ("true".equals(this.policy.getDirective("useXHTML"))) {
                object = new XHTMLSerializer((Writer)object2, outputFormat);
                object.serialize(this.dom);
            } else {
                object = new HTMLSerializer((Writer)object2, outputFormat);
                object.serialize(this.dom);
            }
            object = ((StringWriter)object2).getBuffer().toString();
            if ("true".equals(this.policy.getDirective("omitXmlDeclaration"))) {
                int n2 = ((String)object).indexOf("<?xml");
                int n3 = ((String)object).indexOf("?>");
                if (n2 != -1 && n2 != -1 && n2 < n3) {
                    object = ((String)object).substring(n3 + 1);
                }
            }
            this.results = new CleanResults(date, new Date(), (String)object, this.dom, this.errorMessages);
            return this.results;
        }
        catch (SAXException sAXException) {
            throw new ScanException(sAXException);
        }
        catch (IOException iOException) {
            throw new ScanException(iOException);
        }
    }

    private void recursiveValidateTag(Node node) {
        if (node instanceof Comment) {
            node.getParentNode().removeChild(node);
        }
        if (!(node instanceof Element)) {
            return;
        }
        Element element = (Element)node;
        Node node2 = element.getParentNode();
        Node node3 = null;
        String string = element.getNodeName();
        Tag tag = this.policy.getTagByName(string.toLowerCase());
        if (tag == null || "filter".equals(tag.getAction())) {
            if (tag == null) {
                this.addError("error.tag.notfound", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)});
            } else {
                this.addError("error.tag.filtered", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)});
            }
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                node3 = node.getChildNodes().item(i);
                this.recursiveValidateTag(node3);
                if (node3.getParentNode() != null) continue;
                --i;
            }
            this.promoteChildren(element);
            return;
        }
        if ("validate".equals(tag.getAction())) {
            int n;
            Object object;
            if ("style".equals(string.toLowerCase()) && this.policy.getTagByName("style") != null) {
                object = new CssScanner(this.policy);
                try {
                    CleanResults cleanResults = ((CssScanner)object).scanStyleSheet(node.getFirstChild().getNodeValue(), this.policy.getMaxInputSize());
                    this.errorMessages.addAll(cleanResults.getErrorMessages());
                    if (cleanResults.getCleanHTML() == null || cleanResults.getCleanHTML().equals("")) {
                        node.getFirstChild().setNodeValue("/* */");
                    } else {
                        node.getFirstChild().setNodeValue(cleanResults.getCleanHTML());
                    }
                }
                catch (DOMException dOMException) {
                    this.addError("error.css.tag.malformed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getFirstChild().getNodeValue())});
                    node2.removeChild(node);
                    return;
                }
                catch (ScanException scanException) {
                    this.addError("error.css.tag.malformed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(node.getFirstChild().getNodeValue())});
                    node2.removeChild(node);
                    return;
                }
            }
            object = null;
            for (n = 0; n < element.getAttributes().getLength(); ++n) {
                Object object2;
                Object object3;
                Object object4;
                object = element.getAttributes().item(n);
                String string2 = object.getNodeName();
                String string3 = object.getNodeValue();
                Attribute attribute = tag.getAttributeByName(string2);
                if (attribute == null) {
                    attribute = this.policy.getGlobalAttributeByName(string2);
                }
                boolean bl = false;
                if ("style".equals(string2.toLowerCase()) && attribute != null) {
                    object4 = new CssScanner(this.policy);
                    try {
                        object3 = ((CssScanner)object4).scanInlineStyle(string3, string, this.policy.getMaxInputSize());
                        object.setNodeValue(((CleanResults)object3).getCleanHTML());
                        object2 = ((CleanResults)object3).getErrorMessages();
                        this.errorMessages.addAll(object2);
                    }
                    catch (DOMException dOMException) {
                        this.addError("error.css.attribute.malformed", new Object[]{string, HTMLEntityEncoder.htmlEntityEncode(node.getNodeValue())});
                        element.removeAttribute(string2);
                        --n;
                    }
                    catch (ScanException scanException) {
                        this.addError("error.css.attribute.malformed", new Object[]{string, HTMLEntityEncoder.htmlEntityEncode(node.getNodeValue())});
                        element.removeAttribute(string2);
                        --n;
                    }
                    continue;
                }
                if (attribute != null) {
                    object4 = attribute.getAllowedValues().iterator();
                    while (object4.hasNext() && !bl) {
                        object3 = (String)object4.next();
                        if (object3 == null || !((String)object3).toLowerCase().equals(string3.toLowerCase())) continue;
                        bl = true;
                    }
                    object3 = attribute.getAllowedRegExp().iterator();
                    while (object3.hasNext() && !bl) {
                        object2 = (Pattern)object3.next();
                        if (object2 == null || !((Pattern)object2).matcher(string3.toLowerCase()).matches()) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    object2 = attribute.getOnInvalid();
                    if ("removeTag".equals(object2)) {
                        node2.removeChild(element);
                        this.addError("error.attribute.invalid.removed", new Object[]{string, HTMLEntityEncoder.htmlEntityEncode(string2), HTMLEntityEncoder.htmlEntityEncode(string3)});
                        continue;
                    }
                    if ("filterTag".equals(object2)) {
                        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                            node3 = node.getChildNodes().item(i);
                            this.recursiveValidateTag(node3);
                            if (node3.getParentNode() != null) continue;
                            --i;
                        }
                        this.promoteChildren(element);
                        this.addError("error.attribute.invalid.filtered", new Object[]{string, HTMLEntityEncoder.htmlEntityEncode(string2), HTMLEntityEncoder.htmlEntityEncode(string3)});
                        continue;
                    }
                    element.removeAttribute(attribute.getName());
                    --n;
                    this.addError("error.attribute.invalid", new Object[]{string, HTMLEntityEncoder.htmlEntityEncode(string2), HTMLEntityEncoder.htmlEntityEncode(string3)});
                    if (!"removeTag".equals(object2) && !"filterTag".equals(object2)) continue;
                    return;
                }
                this.addError("error.attribute.notfound", new Object[]{string, HTMLEntityEncoder.htmlEntityEncode(string2)});
                element.removeAttribute(string2);
                --n;
            }
            for (n = 0; n < node.getChildNodes().getLength(); ++n) {
                node3 = node.getChildNodes().item(n);
                this.recursiveValidateTag(node3);
                if (node3.getParentNode() != null) continue;
                --n;
            }
            return;
        }
        if ("truncate".equals(tag.getAction())) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            while (namedNodeMap.getLength() > 0) {
                this.addError("error.attribute.notfound", new Object[]{string, HTMLEntityEncoder.htmlEntityEncode(namedNodeMap.item(0).getNodeName())});
                element.removeAttribute(namedNodeMap.item(0).getNodeName());
            }
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node4 = nodeList.item(n);
                if (node4.getNodeType() != 3) {
                    element.removeChild(node4);
                    continue;
                }
                ++n;
            }
        } else {
            this.addError("error.tag.removed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)});
            node2.removeChild(element);
        }
    }

    private void addError(String string, Object[] objectArray) {
        this.errorMessages.add(ErrorMessageUtil.getMessage(string, objectArray));
    }

    public static void main(String[] stringArray) throws PolicyException {
    }

    public AntiSamyDOMScanner(Policy policy) {
        this.policy = policy;
    }

    public AntiSamyDOMScanner() throws PolicyException {
        this.policy = Policy.getInstance();
    }

    public CleanResults getResults() {
        return this.results;
    }

    public void setResults(CleanResults cleanResults) {
        this.results = cleanResults;
    }

    private void promoteChildren(Element element) {
        NodeList nodeList = element.getChildNodes();
        Node node = element.getParentNode();
        while (nodeList.getLength() > 0) {
            Node node2 = element.removeChild(nodeList.item(0));
            node.insertBefore(node2, element);
        }
        node.removeChild(element);
    }

    private String stripNonValidXMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || "".equals(string)) {
            return "";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void debug(String string) {
        System.out.println(string);
    }
}

