/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.owasp.validator.html.model.Attribute;

public class Tag {
    private HashMap allowedAttributes = new HashMap();
    private String name;
    private String action;
    private static final String ANY_NORMAL_WHITESPACES = "(\\s)*";
    private static final String OPEN_ATTRIBUTE = "(";
    private static final String ATTRIBUTE_DIVIDER = "|";
    private static final String CLOSE_ATTRIBUTE = ")";
    private static final String OPEN_TAG_ATTRIBUTES = "(\\s)*(";
    private static final String CLOSE_TAG_ATTRIBUTES = ")*";
    private static final String REGEXP_CHARACTERS = "\\(){}.*?$^-+";

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public Tag(String string) {
        this.name = string;
    }

    public void addAttribute(Attribute attribute) {
        this.allowedAttributes.put(attribute.getName().toLowerCase(), attribute);
    }

    public String getRegularExpression() {
        if (this.allowedAttributes.size() == 0) {
            return "^<" + this.name + ">$";
        }
        StringBuffer stringBuffer = new StringBuffer("<(\\s)*" + this.name + OPEN_TAG_ATTRIBUTES);
        Iterator iterator = this.allowedAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Attribute attribute = (Attribute)this.allowedAttributes.get((String)iterator.next());
            stringBuffer.append(attribute.getName() + ANY_NORMAL_WHITESPACES + "=" + ANY_NORMAL_WHITESPACES + "\"" + OPEN_ATTRIBUTE);
            Iterator iterator2 = attribute.getAllowedValues().iterator();
            Iterator iterator3 = attribute.getAllowedRegExp().iterator();
            if (attribute.getAllowedRegExp().size() + attribute.getAllowedValues().size() <= 0) continue;
            while (iterator2.hasNext()) {
                object = (String)iterator2.next();
                stringBuffer.append(this.escapeRegularExpressionCharacters((String)object));
                if (!iterator2.hasNext() && !iterator3.hasNext()) continue;
                stringBuffer.append(ATTRIBUTE_DIVIDER);
            }
            while (iterator3.hasNext()) {
                object = (Pattern)iterator3.next();
                stringBuffer.append(((Pattern)object).pattern());
                if (!iterator3.hasNext()) continue;
                stringBuffer.append(ATTRIBUTE_DIVIDER);
            }
            if (attribute.getAllowedRegExp().size() + attribute.getAllowedValues().size() > 0) {
                stringBuffer.append(CLOSE_ATTRIBUTE);
            }
            stringBuffer.append("\"(\\s)*");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(ATTRIBUTE_DIVIDER);
        }
        stringBuffer.append(")*(\\s)*>");
        return stringBuffer.toString();
    }

    private String escapeRegularExpressionCharacters(String string) {
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        for (int i = 0; i < REGEXP_CHARACTERS.length(); ++i) {
            string2.replaceAll("\\" + String.valueOf(REGEXP_CHARACTERS.charAt(i)), "\\" + REGEXP_CHARACTERS.charAt(i));
        }
        return string2;
    }

    public HashMap getAllowedAttributes() {
        return this.allowedAttributes;
    }

    public void setAllowedAttributes(HashMap hashMap) {
        this.allowedAttributes = hashMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Attribute getAttributeByName(String string) {
        return (Attribute)this.allowedAttributes.get(string);
    }
}

