/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.model.AntiSamyPattern;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Property;
import org.owasp.validator.html.model.Tag;
import org.owasp.validator.html.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Policy {
    private static Policy _instance = null;
    private static final String DEFAULT_POLICY_URI = "resources/antisamy.xml";
    private static final String DEFAULT_ONINVALID = "removeAttribute";
    public static final int DEFAULT_MAX_INPUT_SIZE = 100000;
    public static final int DEFAULT_MAX_STYLESHEET_IMPORTS = 1;
    public static final String OMIT_XML_DECLARATION = "omitXmlDeclaration";
    public static final String OMIT_DOCTYPE_DECLARATION = "omitDoctypeDeclaration";
    public static final String MAX_INPUT_SIZE = "maxInputSize";
    public static final String USE_XHTML = "useXHTML";
    public static final String FORMAT_OUTPUT = "formatOutput";
    public static final String EMBED_STYLESHEETS = "embedStyleSheets";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    private static char REGEXP_BEGIN = (char)94;
    private static char REGEXP_END = (char)36;
    private HashMap commonRegularExpressions;
    private HashMap commonAttributes;
    private HashMap tagRules;
    private HashMap cssRules;
    private HashMap directives;
    private HashMap globalAttributes;
    private ArrayList tagNames;

    public Tag getTagByName(String string) {
        return (Tag)this.tagRules.get(string.toLowerCase());
    }

    public Property getPropertyByName(String string) {
        return (Property)this.cssRules.get(string.toLowerCase());
    }

    public static Policy getInstance() throws PolicyException {
        try {
            _instance = new Policy(new FileInputStream(DEFAULT_POLICY_URI));
        }
        catch (IOException iOException) {
            throw new PolicyException(iOException);
        }
        return _instance;
    }

    public static Policy getInstance(String string) throws PolicyException {
        try {
            _instance = new Policy(new FileInputStream(string));
        }
        catch (IOException iOException) {
            throw new PolicyException(iOException);
        }
        return _instance;
    }

    public static Policy getInstance(File file) throws PolicyException {
        try {
            _instance = new Policy(new FileInputStream(file.getAbsoluteFile()));
        }
        catch (IOException iOException) {
            throw new PolicyException(iOException);
        }
        return _instance;
    }

    private Policy(File file) throws PolicyException, IOException {
        this(new FileInputStream(file));
    }

    public static Policy getInstance(InputStream inputStream) throws PolicyException {
        _instance = new Policy(inputStream);
        return _instance;
    }

    private Policy(InputStream inputStream) throws PolicyException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            Element element2 = (Element)element.getElementsByTagName("common-regexps").item(0);
            this.commonRegularExpressions = this.parseCommonRegExps(element2);
            Element element3 = (Element)element.getElementsByTagName("directives").item(0);
            this.directives = this.parseDirectives(element3);
            Element element4 = (Element)element.getElementsByTagName("common-attributes").item(0);
            this.commonAttributes = this.parseCommonAttributes(element4);
            Element element5 = (Element)element.getElementsByTagName("global-tag-attributes").item(0);
            this.globalAttributes = this.parseGlobalAttributes(element5);
            Element element6 = (Element)element.getElementsByTagName("tag-rules").item(0);
            this.tagRules = this.parseTagRules(element6);
            Element element7 = (Element)element.getElementsByTagName("css-rules").item(0);
            this.cssRules = this.parseCSSRules(element7);
        }
        catch (SAXException sAXException) {
            throw new PolicyException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PolicyException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new PolicyException(iOException);
        }
    }

    private HashMap parseDirectives(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = element.getElementsByTagName("directive");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttributeValue(element2, "name");
            String string2 = XMLUtil.getAttributeValue(element2, "value");
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private HashMap parseGlobalAttributes(Element element) throws PolicyException {
        HashMap<String, Attribute> hashMap = new HashMap<String, Attribute>();
        NodeList nodeList = element.getElementsByTagName("attribute");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttributeValue(element2, "name");
            Attribute attribute = this.getCommonAttributeByName(string);
            if (attribute == null) {
                throw new PolicyException("Global attribute '" + string + "' was not defined in <common-attributes>");
            }
            hashMap.put(string.toLowerCase(), attribute);
        }
        return hashMap;
    }

    private HashMap parseCommonRegExps(Element element) {
        HashMap<String, AntiSamyPattern> hashMap = new HashMap<String, AntiSamyPattern>();
        NodeList nodeList = element.getElementsByTagName("regexp");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttributeValue(element2, "name");
            Pattern pattern = Pattern.compile(XMLUtil.getAttributeValue(element2, "value"));
            hashMap.put(string, new AntiSamyPattern(string, pattern));
        }
        return hashMap;
    }

    private HashMap parseCommonAttributes(Element element) {
        HashMap<String, Attribute> hashMap = new HashMap<String, Attribute>();
        NodeList nodeList = element.getElementsByTagName("attribute");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Object object;
            Object object2;
            Element element2 = (Element)nodeList.item(i);
            String string2 = XMLUtil.getAttributeValue(element2, "onInvalid");
            String string3 = XMLUtil.getAttributeValue(element2, "name");
            Attribute attribute = new Attribute(XMLUtil.getAttributeValue(element2, "name"));
            attribute.setDescription(XMLUtil.getAttributeValue(element2, "description"));
            if (string2 != null && string2.length() > 0) {
                attribute.setOnInvalid(string2);
            } else {
                attribute.setOnInvalid(DEFAULT_ONINVALID);
            }
            Element element3 = (Element)element2.getElementsByTagName("regexp-list").item(0);
            if (element3 != null) {
                object2 = element3.getElementsByTagName("regexp");
                for (int j = 0; j < object2.getLength(); ++j) {
                    Element element4 = (Element)object2.item(j);
                    object = XMLUtil.getAttributeValue(element4, "name");
                    string = XMLUtil.getAttributeValue(element4, "value");
                    if (object != null && ((String)object).length() > 0) {
                        attribute.addAllowedRegExp(this.getRegularExpression((String)object).getPattern());
                        continue;
                    }
                    attribute.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + string + REGEXP_END));
                }
            }
            if ((object2 = (Element)element2.getElementsByTagName("literal-list").item(0)) != null) {
                NodeList nodeList2 = object2.getElementsByTagName("literal");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    object = (Element)nodeList2.item(j);
                    string = XMLUtil.getAttributeValue((Element)object, "value");
                    if (string != null && string.length() > 0) {
                        attribute.addAllowedValue(string);
                        continue;
                    }
                    if (object.getNodeValue() == null) continue;
                    attribute.addAllowedValue(object.getNodeValue());
                }
            }
            hashMap.put(string3.toLowerCase(), attribute);
        }
        return hashMap;
    }

    private HashMap parseTagRules(Element element) throws PolicyException {
        HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
        NodeList nodeList = element.getElementsByTagName("tag");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttributeValue(element2, "name");
            String string2 = XMLUtil.getAttributeValue(element2, "action");
            Tag tag = new Tag(string);
            if (this.tagNames == null) {
                this.tagNames = new ArrayList();
            }
            this.tagNames.add(string);
            tag.setAction(string2);
            NodeList nodeList2 = element2.getElementsByTagName("attribute");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string3;
                Object object;
                Object object2;
                Object object3;
                Attribute attribute;
                Element element3 = (Element)nodeList2.item(j);
                if (!element3.hasChildNodes()) {
                    attribute = this.getCommonAttributeByName(XMLUtil.getAttributeValue(element3, "name"));
                    if (attribute != null) {
                        object3 = XMLUtil.getAttributeValue(element3, "onInvalid");
                        object2 = XMLUtil.getAttributeValue(element3, "description");
                        if (object3 != null && ((String)object3).length() != 0) {
                            attribute.setOnInvalid((String)object3);
                        }
                        if (object2 != null && ((String)object2).length() != 0) {
                            attribute.setDescription((String)object2);
                        }
                        tag.addAttribute((Attribute)attribute.clone());
                        continue;
                    }
                    throw new PolicyException("Attribute '" + XMLUtil.getAttributeValue(element3, "name") + "' was referenced as a common attribute in definition of '" + tag.getName() + "', but does not exist in <common-attributes>");
                }
                attribute = new Attribute(XMLUtil.getAttributeValue(element3, "name"));
                attribute.setOnInvalid(XMLUtil.getAttributeValue(element3, "onInvalid"));
                attribute.setDescription(XMLUtil.getAttributeValue(element3, "description"));
                object3 = (Element)element3.getElementsByTagName("regexp-list").item(0);
                if (object3 != null) {
                    object2 = object3.getElementsByTagName("regexp");
                    for (int k = 0; k < object2.getLength(); ++k) {
                        Element element4 = (Element)object2.item(k);
                        object = XMLUtil.getAttributeValue(element4, "name");
                        string3 = XMLUtil.getAttributeValue(element4, "value");
                        if (object != null && ((String)object).length() > 0) {
                            AntiSamyPattern antiSamyPattern = this.getRegularExpression((String)object);
                            if (antiSamyPattern != null) {
                                attribute.addAllowedRegExp(antiSamyPattern.getPattern());
                                continue;
                            }
                            throw new PolicyException("Regular expression '" + (String)object + "' was referenced as a common regexp in definition of '" + tag.getName() + "', but does not exist in <common-regexp>");
                        }
                        if (string3 == null || string3.length() <= 0) continue;
                        attribute.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + string3 + REGEXP_END));
                    }
                }
                if ((object2 = (Element)element3.getElementsByTagName("literal-list").item(0)) != null) {
                    NodeList nodeList3 = object2.getElementsByTagName("literal");
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        object = (Element)nodeList3.item(k);
                        string3 = XMLUtil.getAttributeValue((Element)object, "value");
                        if (string3 != null && string3.length() > 0) {
                            attribute.addAllowedValue(string3);
                            continue;
                        }
                        if (object.getNodeValue() == null) continue;
                        attribute.addAllowedValue(object.getNodeValue());
                    }
                }
                tag.addAttribute(attribute);
            }
            hashMap.put(string.toLowerCase(), tag);
        }
        return hashMap;
    }

    private HashMap parseCSSRules(Element element) throws PolicyException {
        HashMap<String, Property> hashMap = new HashMap<String, Property>();
        NodeList nodeList = element.getElementsByTagName("property");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Object object;
            Object object2;
            Object object3;
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttributeValue(element3, "name");
            String string2 = XMLUtil.getAttributeValue(element3, "description");
            Property property = new Property(string);
            property.setDescription(string2);
            String string3 = XMLUtil.getAttributeValue(element3, "onInvalid");
            if (string3 != null && string3.length() > 0) {
                property.setOnInvalid(string3);
            } else {
                property.setOnInvalid(DEFAULT_ONINVALID);
            }
            Element element4 = (Element)element3.getElementsByTagName("regexp-list").item(0);
            if (element4 != null) {
                object3 = element4.getElementsByTagName("regexp");
                for (int j = 0; j < object3.getLength(); ++j) {
                    Element element5 = (Element)object3.item(j);
                    object2 = XMLUtil.getAttributeValue(element5, "name");
                    object = XMLUtil.getAttributeValue(element5, "value");
                    AntiSamyPattern antiSamyPattern = this.getRegularExpression((String)object2);
                    if (antiSamyPattern != null) {
                        property.addAllowedRegExp(antiSamyPattern.getPattern());
                        continue;
                    }
                    if (object != null) {
                        property.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + (String)object + REGEXP_END));
                        continue;
                    }
                    throw new PolicyException("Regular expression '" + (String)object2 + "' was referenced as a common regexp in definition of '" + property.getName() + "', but does not exist in <common-regexp>");
                }
            }
            if ((object3 = (Element)element3.getElementsByTagName("literal-list").item(0)) != null) {
                NodeList nodeList2 = object3.getElementsByTagName("literal");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    object2 = (Element)nodeList2.item(j);
                    property.addAllowedValue(XMLUtil.getAttributeValue((Element)object2, "value"));
                }
            }
            if ((element2 = (Element)element3.getElementsByTagName("shorthand-list").item(0)) != null) {
                NodeList nodeList3 = element2.getElementsByTagName("shorthand");
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    object = (Element)nodeList3.item(j);
                    property.addShorthandRef(XMLUtil.getAttributeValue((Element)object, "name"));
                }
            }
            hashMap.put(string.toLowerCase(), property);
        }
        return hashMap;
    }

    public AntiSamyPattern getRegularExpression(String string) {
        return (AntiSamyPattern)this.commonRegularExpressions.get(string);
    }

    public Attribute getGlobalAttributeByName(String string) {
        return (Attribute)this.globalAttributes.get(string.toLowerCase());
    }

    private Attribute getCommonAttributeByName(String string) {
        return (Attribute)this.commonAttributes.get(string.toLowerCase());
    }

    public String[] getTags() {
        return this.tagNames.toArray(new String[1]);
    }

    public String getDirective(String string) {
        return (String)this.directives.get(string);
    }

    public int getMaxInputSize() {
        int n = 100000;
        try {
            n = Integer.parseInt(this.getDirective(MAX_INPUT_SIZE));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(new File(DEFAULT_POLICY_URI));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource streamSource = new StreamSource(new File("resources/antisamy.xsd"));
        Schema schema = schemaFactory.newSchema(streamSource);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(document));
            System.out.println("made it through!");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }
}

