/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.scan.AntiSamyDOMScanner;

public class AntiSamy {
    private String inputEncoding = "UTF-8";
    private String outputEncoding = "UTF-8";
    private Policy policy = null;

    public AntiSamy() {
    }

    public AntiSamy(Policy policy) {
        this.policy = policy;
    }

    public CleanResults scan(String string) throws ScanException, PolicyException {
        if (this.policy == null) {
            throw new PolicyException("No policy loaded");
        }
        AntiSamyDOMScanner antiSamyDOMScanner = new AntiSamyDOMScanner(this.policy);
        return antiSamyDOMScanner.scan(string, this.inputEncoding, this.outputEncoding);
    }

    public CleanResults scan(String string, Policy policy) throws ScanException, PolicyException {
        return new AntiSamyDOMScanner(policy).scan(string, this.inputEncoding, this.outputEncoding);
    }

    public CleanResults scan(String string, String string2) throws ScanException, PolicyException {
        Policy policy = null;
        policy = Policy.getInstance(string2);
        AntiSamyDOMScanner antiSamyDOMScanner = new AntiSamyDOMScanner(policy);
        return antiSamyDOMScanner.scan(string, this.inputEncoding, this.outputEncoding);
    }

    public CleanResults scan(String string, File file) throws ScanException, PolicyException {
        Policy policy = null;
        policy = Policy.getInstance(file);
        AntiSamyDOMScanner antiSamyDOMScanner = new AntiSamyDOMScanner(policy);
        return antiSamyDOMScanner.scan(string, this.inputEncoding, this.outputEncoding);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Please specify a URL or file name to filter - thanks!");
            return;
        }
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            URL uRL = null;
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                uRL = new URL(stringArray[0]);
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    fileReader = new FileReader(new File(stringArray[0]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("Please specify a URL or file name to filter - thanks!");
                    return;
                }
                bufferedReader = new BufferedReader(fileReader);
            }
            catch (IOException iOException) {
                System.err.println("Encountered an IOException while reading URL: ");
                iOException.printStackTrace();
            }
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            bufferedReader.close();
            AntiSamy antiSamy = new AntiSamy();
            CleanResults cleanResults = antiSamy.scan(stringBuffer.toString(), Policy.getInstance("resources/antisamy-ebay-1.2.xml"));
            System.out.println("[1] Finished scan [" + cleanResults.getCleanHTML().length() + " bytes] in " + cleanResults.getScanTime() + " seconds");
            System.out.println("\n[2] Clean HTML fragment:\n" + cleanResults.getCleanHTML());
            System.out.println("[3] Error Messages (" + cleanResults.getNumberOfErrors() + "):");
            for (int i = 0; i < cleanResults.getErrorMessages().size(); ++i) {
                String string2 = (String)cleanResults.getErrorMessages().get(i);
                System.out.println(string2);
            }
            antiSamy.scan("<img alt=\"\" src=\"http://profileflirts.com/pics/awareness/troops/0001.gif\" />", Policy.getInstance("resources/antisamy-ebay-1.2.xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String string) {
        this.inputEncoding = string;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }
}

