/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.owasp.validator.css.UnknownSelectorException;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.model.AntiSamyPattern;
import org.owasp.validator.html.model.Property;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class CssValidator {
    private final Policy policy;

    public CssValidator(Policy policy) {
        this.policy = policy;
    }

    public boolean isValidProperty(String string, LexicalUnit lexicalUnit) {
        boolean bl = false;
        Property property = null;
        if (string != null) {
            property = this.policy.getPropertyByName(string.toLowerCase());
        }
        if (property != null) {
            bl = true;
            while (lexicalUnit != null) {
                String string2 = this.lexicalValueToString(lexicalUnit);
                if (string2 == null || !this.validateValue(property, string2)) {
                    bl = false;
                    break;
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
        }
        return bl;
    }

    public boolean isValidSelector(String string, Selector selector) throws ScanException {
        switch (selector.getSelectorType()) {
            case 1: 
            case 2: 
            case 4: 
            case 9: {
                return this.validateSimpleSelector((SimpleSelector)selector);
            }
            case 10: 
            case 11: {
                DescendantSelector descendantSelector = (DescendantSelector)selector;
                return this.isValidSelector(string, (Selector)descendantSelector.getSimpleSelector()) & this.isValidSelector(string, descendantSelector.getAncestorSelector());
            }
            case 0: {
                ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                return this.isValidSelector(string, (Selector)conditionalSelector.getSimpleSelector()) & this.isValidCondition(string, conditionalSelector.getCondition());
            }
            case 12: {
                SiblingSelector siblingSelector = (SiblingSelector)selector;
                return this.isValidSelector(string, (Selector)siblingSelector.getSiblingSelector()) & this.isValidSelector(string, siblingSelector.getSelector());
            }
            case 3: {
                return this.validateSimpleSelector((SimpleSelector)((NegativeSelector)selector));
            }
        }
        throw new UnknownSelectorException(HTMLEntityEncoder.htmlEntityEncode(selector.toString()));
    }

    private boolean validateSimpleSelector(SimpleSelector simpleSelector) {
        return this.policy.getRegularExpression("cssElementSelector").getPattern().matcher(simpleSelector.toString().toLowerCase()).matches() & !this.policy.getRegularExpression("cssElementExclusion").getPattern().matcher(simpleSelector.toString().toLowerCase()).matches();
    }

    public boolean isValidCondition(String string, Condition condition) throws ScanException {
        switch (condition.getConditionType()) {
            case 0: 
            case 1: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                return this.isValidCondition(string, combinatorCondition.getFirstCondition()) & this.isValidCondition(string, combinatorCondition.getSecondCondition());
            }
            case 9: {
                return this.validateCondition((AttributeCondition)condition, this.policy.getRegularExpression("cssClassSelector"), this.policy.getRegularExpression("cssClassExclusion"));
            }
            case 5: {
                return this.validateCondition((AttributeCondition)condition, this.policy.getRegularExpression("cssIDSelector"), this.policy.getRegularExpression("cssIDExclusion"));
            }
            case 10: {
                return this.validateCondition((AttributeCondition)condition, this.policy.getRegularExpression("cssPseudoElementSelector"), this.policy.getRegularExpression("cssPsuedoElementExclusion"));
            }
            case 4: 
            case 7: 
            case 8: {
                return this.validateCondition((AttributeCondition)condition, this.policy.getRegularExpression("cssAttributeSelector"), this.policy.getRegularExpression("cssAttributeExclusion"));
            }
            case 2: {
                return this.isValidCondition(string, ((NegativeCondition)condition).getCondition());
            }
            case 11: 
            case 12: {
                return true;
            }
        }
        throw new UnknownSelectorException(HTMLEntityEncoder.htmlEntityEncode(string));
    }

    private boolean validateCondition(AttributeCondition attributeCondition, AntiSamyPattern antiSamyPattern, AntiSamyPattern antiSamyPattern2) {
        return antiSamyPattern.getPattern().matcher(attributeCondition.toString().toLowerCase()).matches() & !antiSamyPattern2.getPattern().matcher(attributeCondition.toString().toLowerCase()).matches();
    }

    private boolean validateValue(Property property, String string) {
        Object object;
        Object object2;
        boolean bl = false;
        string = string.toLowerCase();
        Iterator iterator = property.getAllowedValues().iterator();
        while (iterator.hasNext() && !bl) {
            object2 = (String)iterator.next();
            if (object2 == null || !((String)object2).equals(string)) continue;
            bl = true;
        }
        object2 = property.getAllowedRegExp().iterator();
        while (object2.hasNext() && !bl) {
            object = (Pattern)object2.next();
            if (object == null || !((Pattern)object).matcher(string).matches()) continue;
            bl = true;
        }
        object = property.getShorthandRefs().iterator();
        while (object.hasNext() && !bl) {
            String string2 = (String)object.next();
            Property property2 = this.policy.getPropertyByName(string2);
            if (property2 == null) continue;
            bl = this.validateValue(property2, string);
        }
        return bl;
    }

    public String lexicalValueToString(LexicalUnit lexicalUnit) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                return lexicalUnit.getFloatValue() + lexicalUnit.getDimensionUnitText();
            }
            case 13: {
                return String.valueOf(lexicalUnit.getIntegerValue());
            }
            case 14: {
                return String.valueOf(lexicalUnit.getFloatValue());
            }
            case 35: 
            case 36: {
                return lexicalUnit.getStringValue();
            }
            case 24: {
                return "url(" + lexicalUnit.getStringValue() + ")";
            }
            case 27: {
                StringBuffer stringBuffer = new StringBuffer("rgb(");
                LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
                stringBuffer.append(lexicalUnit2.getIntegerValue());
                stringBuffer.append(',');
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                stringBuffer.append(lexicalUnit2.getIntegerValue());
                stringBuffer.append(',');
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                stringBuffer.append(lexicalUnit2.getIntegerValue());
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 12: {
                return "inherit";
            }
        }
        return null;
    }
}

