/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.apache.batik.css.parser.Parser;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpContentTooLargeException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.owasp.validator.css.CssHandler;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.util.ErrorMessageUtil;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;

public class CssScanner {
    private static final int DEFAULT_TIMEOUT = 1000;
    private final Parser parser = new Parser();
    private final Policy policy;

    public CssScanner(Policy policy) {
        this.policy = policy;
    }

    public CleanResults scanStyleSheet(String string, int n) throws ScanException {
        Date date = new Date();
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = new LinkedList();
        CssHandler cssHandler = new CssHandler(this.policy, linkedList, arrayList);
        this.parser.setDocumentHandler((DocumentHandler)cssHandler);
        try {
            this.parser.parseStyleSheet(new InputSource((Reader)new StringReader(string)));
        }
        catch (IOException iOException) {
            throw new ScanException(iOException);
        }
        this.parseImportedStylesheets(linkedList, cssHandler, arrayList, n);
        return new CleanResults(date, new Date(), cssHandler.getCleanStylesheet(), null, arrayList);
    }

    public CleanResults scanInlineStyle(String string, String string2, int n) throws ScanException {
        Date date = new Date();
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = new LinkedList();
        CssHandler cssHandler = new CssHandler(this.policy, linkedList, arrayList, string2);
        this.parser.setDocumentHandler((DocumentHandler)cssHandler);
        try {
            this.parser.parseStyleDeclaration(string);
        }
        catch (IOException iOException) {
            throw new ScanException(iOException);
        }
        this.parseImportedStylesheets(linkedList, cssHandler, arrayList, n);
        return new CleanResults(date, new Date(), cssHandler.getCleanStylesheet(), null, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseImportedStylesheets(LinkedList linkedList, CssHandler cssHandler, ArrayList arrayList, int n) throws ScanException {
        int n2 = 0;
        if (!linkedList.isEmpty()) {
            HttpClient httpClient = new HttpClient();
            HttpConnectionManagerParams httpConnectionManagerParams = httpClient.getHttpConnectionManager().getParams();
            int n3 = 1000;
            try {
                n3 = Integer.parseInt(this.policy.getDirective("connectionTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            httpConnectionManagerParams.setConnectionTimeout(n3);
            httpConnectionManagerParams.setSoTimeout(n3);
            httpClient.getHttpConnectionManager().setParams(httpConnectionManagerParams);
            int n4 = 1;
            try {
                n4 = Integer.parseInt(this.policy.getDirective("maxStyleSheetImports"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            while (!linkedList.isEmpty()) {
                URI uRI = (URI)linkedList.removeFirst();
                if (++n2 > n4) {
                    arrayList.add(ErrorMessageUtil.getMessage("error.css.import.exceeded", new Object[]{HTMLEntityEncoder.htmlEntityEncode(uRI.toString()), String.valueOf(n4)}));
                    continue;
                }
                GetMethod getMethod = new GetMethod(uRI.toString());
                byte[] byArray = null;
                try {
                    httpClient.executeMethod((HttpMethod)getMethod);
                    byArray = getMethod.getResponseBody(n);
                }
                catch (HttpContentTooLargeException httpContentTooLargeException) {
                    arrayList.add(ErrorMessageUtil.getMessage("error.css.import.toolarge", new Object[]{HTMLEntityEncoder.htmlEntityEncode(uRI.toString()), String.valueOf(this.policy.getMaxInputSize())}));
                }
                catch (IOException iOException) {
                    arrayList.add(ErrorMessageUtil.getMessage("error.css.import.failure", new Object[]{HTMLEntityEncoder.htmlEntityEncode(uRI.toString())}));
                }
                finally {
                    getMethod.releaseConnection();
                }
                if (byArray == null) continue;
                n -= byArray.length;
                try {
                    InputSource inputSource = new InputSource((Reader)new InputStreamReader(new ByteArrayInputStream(byArray)));
                    this.parser.parseStyleSheet(inputSource);
                }
                catch (IOException iOException) {
                    throw new ScanException(iOException);
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Policy policy = Policy.getInstance("resources/antisamy-1.2.xml");
        CssScanner cssScanner = new CssScanner(policy);
        CleanResults cleanResults = null;
        cleanResults = cssScanner.scanStyleSheet("@import url(http://www.owasp.org/skins/monobook/main.css);@import url(http://www.w3schools.com/stdtheme.css);@import url(http://www.google.com/ig/f/t1wcX5O39cc/ig.css); ", Integer.MAX_VALUE);
        System.out.println("Cleaned result:");
        System.out.println(cleanResults.getCleanHTML());
        System.out.println("--");
        System.out.println("Error messages");
        System.out.println(cleanResults.getErrorMessages());
    }
}

