/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.owasp.validator.css.CssValidator;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.util.ErrorMessageUtil;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class CssHandler
implements DocumentHandler {
    private StringBuffer styleSheet = new StringBuffer();
    private final CssValidator validator;
    private final Policy policy;
    private final Collection errorMessages;
    private final LinkedList importedStyleSheets;
    private final String tagName;
    private final boolean isInline;
    private boolean selectorOpen = false;

    public CssHandler(Policy policy, LinkedList linkedList, ArrayList arrayList) {
        this(policy, linkedList, arrayList, null);
    }

    public CssHandler(Policy policy, LinkedList linkedList, ArrayList arrayList, String string) {
        this.policy = policy;
        this.errorMessages = arrayList;
        this.validator = new CssValidator(policy);
        this.importedStyleSheets = linkedList;
        this.tagName = string;
        this.isInline = string != null;
    }

    public String getCleanStylesheet() {
        return this.styleSheet.toString();
    }

    public Collection getErrorMessages() {
        return new ArrayList(this.errorMessages);
    }

    public void comment(String string) throws CSSException {
        this.errorMessages.add(ErrorMessageUtil.getMessage("error.comment.removed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)}));
    }

    public void ignorableAtRule(String string) throws CSSException {
        if (this.tagName != null) {
            this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.tag.rule.notfound", new Object[]{HTMLEntityEncoder.htmlEntityEncode(this.tagName), HTMLEntityEncoder.htmlEntityEncode(string)}));
        } else {
            this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.stylesheet.rule.notfound", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)}));
        }
    }

    public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
        if (!Boolean.valueOf(this.policy.getDirective("embedStyleSheets")).booleanValue()) {
            this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.import.disabled", new Object[0]));
            return;
        }
        try {
            if (string == null) {
                this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.import.url.invalid", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)}));
                return;
            }
            URI uRI = new URI(string);
            uRI.normalize();
            if (!this.policy.getRegularExpression("offsiteURL").getPattern().matcher(uRI.toString()).matches() && !this.policy.getRegularExpression("onsiteURL").getPattern().matcher(uRI.toString()).matches()) {
                this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.import.url.invalid", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)}));
                return;
            }
            if (!uRI.isAbsolute()) {
                if (this.tagName != null) {
                    this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.tag.relative", new Object[]{HTMLEntityEncoder.htmlEntityEncode(this.tagName), HTMLEntityEncoder.htmlEntityEncode(string)}));
                } else {
                    this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.stylesheet.relative", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)}));
                }
                return;
            }
            this.importedStyleSheets.add(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.import.url.invalid", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string)}));
            return;
        }
    }

    public void namespaceDeclaration(String string, String string2) throws CSSException {
    }

    public void startDocument(InputSource inputSource) throws CSSException {
    }

    public void endDocument(InputSource inputSource) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
    }

    public void startPage(String string, String string2) throws CSSException {
    }

    public void endPage(String string, String string2) throws CSSException {
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
        int n = 0;
        for (int i = 0; i < selectorList.getLength(); ++i) {
            Selector selector = selectorList.item(i);
            if (selector == null) continue;
            String string = selector.toString();
            boolean bl = false;
            try {
                bl = this.validator.isValidSelector(string, selector);
            }
            catch (ScanException scanException) {
                if (this.tagName != null) {
                    this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.tag.selector.notfound", new Object[]{HTMLEntityEncoder.htmlEntityEncode(selector.toString())}));
                }
                this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.stylesheet.selector.notfound", new Object[]{HTMLEntityEncoder.htmlEntityEncode(this.tagName), HTMLEntityEncoder.htmlEntityEncode(selector.toString())}));
            }
            if (bl) {
                if (n > 0) {
                    this.styleSheet.append(',');
                    this.styleSheet.append(' ');
                }
                this.styleSheet.append(string);
                ++n;
                continue;
            }
            if (this.tagName != null) {
                this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.tag.selector.disallowed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(this.tagName), HTMLEntityEncoder.htmlEntityEncode(selector.toString())}));
                continue;
            }
            this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.stylesheet.selector.disallowed", new Object[]{HTMLEntityEncoder.htmlEntityEncode(selector.toString())}));
        }
        if (n > 0) {
            this.styleSheet.append(' ');
            this.styleSheet.append('{');
            this.styleSheet.append('\n');
            this.selectorOpen = true;
        }
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
        if (this.selectorOpen) {
            this.styleSheet.append('}');
            this.styleSheet.append('\n');
        }
        this.selectorOpen = false;
    }

    public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
        if (!this.selectorOpen && !this.isInline) {
            return;
        }
        if (this.validator.isValidProperty(string, lexicalUnit)) {
            this.styleSheet.append('\t');
            this.styleSheet.append(string);
            this.styleSheet.append(':');
            while (lexicalUnit != null) {
                this.styleSheet.append(' ');
                this.styleSheet.append(this.validator.lexicalValueToString(lexicalUnit));
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
            this.styleSheet.append(';');
            this.styleSheet.append('\n');
        } else if (this.tagName != null) {
            this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.tag.property.invalid", new Object[]{HTMLEntityEncoder.htmlEntityEncode(this.tagName), HTMLEntityEncoder.htmlEntityEncode(string), HTMLEntityEncoder.htmlEntityEncode(this.validator.lexicalValueToString(lexicalUnit))}));
        } else {
            this.errorMessages.add(ErrorMessageUtil.getMessage("error.css.stylesheet.property.invalid", new Object[]{HTMLEntityEncoder.htmlEntityEncode(string), HTMLEntityEncoder.htmlEntityEncode(this.validator.lexicalValueToString(lexicalUnit))}));
        }
    }
}

