/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.owasp.esapi.AccessReferenceMap;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.reference.DefaultEncoder;

public class RandomAccessReferenceMap
implements AccessReferenceMap {
    HashMap itod = new HashMap();
    HashMap dtoi = new HashMap();
    Randomizer random = ESAPI.randomizer();

    public RandomAccessReferenceMap() {
    }

    public RandomAccessReferenceMap(Set set) {
        this.update(set);
    }

    public Iterator iterator() {
        TreeSet treeSet = new TreeSet(this.dtoi.keySet());
        return treeSet.iterator();
    }

    public String addDirectReference(Object object) {
        if (this.dtoi.keySet().contains(object)) {
            return (String)this.dtoi.get(object);
        }
        String string = this.getUniqueRandomReference();
        this.itod.put(string, object);
        this.dtoi.put(object, string);
        return string;
    }

    private String getUniqueRandomReference() {
        String string = null;
        do {
            string = this.random.getRandomString(6, DefaultEncoder.CHAR_ALPHANUMERICS);
        } while (this.itod.keySet().contains(string));
        return string;
    }

    public String removeDirectReference(Object object) throws AccessControlException {
        String string = (String)this.dtoi.get(object);
        if (string != null) {
            this.itod.remove(string);
            this.dtoi.remove(object);
        }
        return string;
    }

    public final void update(Set set) {
        HashMap hashMap = (HashMap)this.dtoi.clone();
        this.dtoi.clear();
        this.itod.clear();
        for (Object e : set) {
            String string = (String)hashMap.get(e);
            if (string == null) {
                string = this.getUniqueRandomReference();
            }
            this.itod.put(string, e);
            this.dtoi.put(e, string);
        }
    }

    public String getIndirectReference(Object object) {
        return (String)this.dtoi.get(object);
    }

    public Object getDirectReference(String string) throws AccessControlException {
        if (this.itod.containsKey(string)) {
            return this.itod.get(string);
        }
        throw new AccessControlException("Access denied", "Request for invalid indirect reference: " + string);
    }
}

