/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.util.HashMap;
import java.util.logging.Level;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;

public class JavaLogFactory
implements LogFactory {
    private String applicationName;
    private HashMap loggersMap = new HashMap();

    public JavaLogFactory(String string) {
        this.applicationName = string;
    }

    public Logger getLogger(Class clazz) {
        Logger logger = (Logger)this.loggersMap.get(clazz);
        if (logger == null) {
            logger = new JavaLogger(this.applicationName, clazz.getName());
            this.loggersMap.put(clazz, logger);
        }
        return logger;
    }

    public Logger getLogger(String string) {
        Logger logger = (Logger)this.loggersMap.get(string);
        if (logger == null) {
            logger = new JavaLogger(this.applicationName, string);
            this.loggersMap.put(string, logger);
        }
        return logger;
    }

    private static class JavaLogger
    implements Logger {
        private java.util.logging.Logger jlogger = null;
        private String applicationName = null;
        private String moduleName = null;
        private static Level currentLevel = JavaLogger.convertESAPILeveltoLoggerLevel(ESAPI.securityConfiguration().getLogLevel());

        private JavaLogger(String string, String string2) {
            this.applicationName = string;
            this.moduleName = string2;
            this.jlogger = java.util.logging.Logger.getLogger(string + ":" + string2);
            this.jlogger.setLevel(currentLevel);
        }

        public void setLevel(int n) {
            try {
                currentLevel = JavaLogger.convertESAPILeveltoLoggerLevel(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error(Logger.SECURITY, false, "", illegalArgumentException);
            }
        }

        private static Level convertESAPILeveltoLoggerLevel(int n) {
            switch (n) {
                case 0x7FFFFFFF: {
                    return Level.OFF;
                }
                case 1000: {
                    return Level.SEVERE;
                }
                case 800: {
                    return JavaLoggerLevel.ERROR_LEVEL;
                }
                case 600: {
                    return Level.WARNING;
                }
                case 400: {
                    return Level.INFO;
                }
                case 200: {
                    return Level.FINE;
                }
                case 100: {
                    return Level.FINEST;
                }
                case -2147483648: {
                    return Level.ALL;
                }
            }
            throw new IllegalArgumentException("Invalid logging level. Value was: " + n);
        }

        public void trace(Logger.EventType eventType, boolean bl, String string, Throwable throwable) {
            this.log(Level.FINEST, eventType, bl, string, throwable);
        }

        public void trace(Logger.EventType eventType, boolean bl, String string) {
            this.log(Level.FINEST, eventType, bl, string, null);
        }

        public void debug(Logger.EventType eventType, boolean bl, String string, Throwable throwable) {
            this.log(Level.FINE, eventType, bl, string, throwable);
        }

        public void debug(Logger.EventType eventType, boolean bl, String string) {
            this.log(Level.FINE, eventType, bl, string, null);
        }

        public void info(Logger.EventType eventType, boolean bl, String string) {
            this.log(Level.INFO, eventType, bl, string, null);
        }

        public void info(Logger.EventType eventType, boolean bl, String string, Throwable throwable) {
            this.log(Level.INFO, eventType, bl, string, throwable);
        }

        public void warning(Logger.EventType eventType, boolean bl, String string, Throwable throwable) {
            this.log(Level.WARNING, eventType, bl, string, throwable);
        }

        public void warning(Logger.EventType eventType, boolean bl, String string) {
            this.log(Level.WARNING, eventType, bl, string, null);
        }

        public void error(Logger.EventType eventType, boolean bl, String string, Throwable throwable) {
            this.log(Level.SEVERE, eventType, bl, string, throwable);
        }

        public void error(Logger.EventType eventType, boolean bl, String string) {
            this.log(Level.SEVERE, eventType, bl, string, null);
        }

        public void fatal(Logger.EventType eventType, boolean bl, String string, Throwable throwable) {
            this.log(Level.SEVERE, eventType, bl, string, throwable);
        }

        public void fatal(Logger.EventType eventType, boolean bl, String string) {
            this.log(Level.SEVERE, eventType, bl, string, null);
        }

        private void log(Level level, Logger.EventType eventType, boolean bl, String string, Throwable throwable) {
            String string2;
            Object object;
            this.jlogger.setLevel(currentLevel);
            if (!this.jlogger.isLoggable(level)) {
                return;
            }
            User user = ESAPI.authenticator().getCurrentUser();
            String string3 = "unknown";
            try {
                object = ESAPI.httpUtilities().getCurrentRequest().getSession(false);
                string3 = (String)object.getAttribute("ESAPI_SESSION");
                if (string3 == null) {
                    string3 = "" + ESAPI.randomizer().getRandomInteger(0, 1000000);
                    object.setAttribute("ESAPI_SESSION", (Object)string3);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (string == null) {
                string = "";
            }
            object = string.replace('\n', '_').replace('\r', '_');
            if (((DefaultSecurityConfiguration)ESAPI.securityConfiguration()).getLogEncodingRequired() && !string.equals(object = ESAPI.encoder().encodeForHTML(string))) {
                object = (String)object + " (Encoded)";
            }
            if (throwable != null) {
                string2 = throwable.getClass().getName();
                int n = string2.lastIndexOf(46);
                if (n > 0) {
                    string2 = string2.substring(n + 1);
                }
                StackTraceElement stackTraceElement = throwable.getStackTrace()[0];
                object = (String)object + "\n    " + string2 + " @ " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
            }
            string2 = "";
            if (user != null) {
                string2 = eventType + "-" + (bl ? "SUCCESS" : "FAILURE") + " " + user.getAccountName() + "@" + user.getLastHostAddress() + ":" + string3 + " -- " + (String)object;
            }
            this.jlogger.logp(level, this.applicationName, this.moduleName, string2);
        }

        public boolean isDebugEnabled() {
            this.jlogger.setLevel(currentLevel);
            return this.jlogger.isLoggable(Level.FINE);
        }

        public boolean isErrorEnabled() {
            this.jlogger.setLevel(currentLevel);
            return this.jlogger.isLoggable(JavaLoggerLevel.ERROR_LEVEL);
        }

        public boolean isFatalEnabled() {
            this.jlogger.setLevel(currentLevel);
            return this.jlogger.isLoggable(Level.SEVERE);
        }

        public boolean isInfoEnabled() {
            this.jlogger.setLevel(currentLevel);
            return this.jlogger.isLoggable(Level.INFO);
        }

        public boolean isTraceEnabled() {
            this.jlogger.setLevel(currentLevel);
            return this.jlogger.isLoggable(Level.FINEST);
        }

        public boolean isWarningEnabled() {
            this.jlogger.setLevel(currentLevel);
            return this.jlogger.isLoggable(Level.WARNING);
        }
    }

    public static class JavaLoggerLevel
    extends Level {
        public static final Level ERROR_LEVEL = new JavaLoggerLevel("ERROR", Level.SEVERE.intValue() - 1);

        protected JavaLoggerLevel(String string, int n) {
            super(string, n);
        }
    }
}

