/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;
import org.owasp.esapi.reference.DefaultEncoder;

public class JavaEncryptor
implements Encryptor {
    PrivateKey privateKey = null;
    PublicKey publicKey = null;
    PBEParameterSpec parameterSpec = null;
    SecretKey secretKey = null;
    String encryptAlgorithm = "PBEWithMD5AndDES";
    String signatureAlgorithm = "SHAwithDSA";
    String hashAlgorithm = "SHA-512";
    String randomAlgorithm = "SHA1PRNG";
    String encoding = "UTF-8";

    public JavaEncryptor() {
        byte[] byArray = ESAPI.securityConfiguration().getMasterSalt();
        char[] cArray = ESAPI.securityConfiguration().getMasterPassword();
        this.encryptAlgorithm = ESAPI.securityConfiguration().getEncryptionAlgorithm();
        this.signatureAlgorithm = ESAPI.securityConfiguration().getDigitalSignatureAlgorithm();
        this.randomAlgorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        this.hashAlgorithm = ESAPI.securityConfiguration().getHashAlgorithm();
        try {
            this.parameterSpec = new PBEParameterSpec(byArray, 20);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.encryptAlgorithm);
            this.secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(cArray));
            this.encoding = ESAPI.securityConfiguration().getCharacterEncoding();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            SecureRandom secureRandom = SecureRandom.getInstance(this.randomAlgorithm);
            byte[] byArray2 = this.hash(new String(cArray), new String(byArray)).getBytes();
            secureRandom.setSeed(byArray2);
            keyPairGenerator.initialize(1024, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = keyPair.getPublic();
        }
        catch (Exception exception) {
            new EncryptionException("Encryption failure", "Error creating Encryptor", exception);
        }
    }

    public String hash(String string, String string2) throws EncryptionException {
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.hashAlgorithm);
            messageDigest.reset();
            messageDigest.update(ESAPI.securityConfiguration().getMasterSalt());
            messageDigest.update(string2.getBytes());
            messageDigest.update(string.getBytes());
            byArray = messageDigest.digest();
            for (int i = 0; i < 1024; ++i) {
                messageDigest.reset();
                byArray = messageDigest.digest(byArray);
            }
            String string3 = ESAPI.encoder().encodeForBase64(byArray, false);
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionException("Internal error", "Can't find hash algorithm " + this.hashAlgorithm, noSuchAlgorithmException);
        }
    }

    public String encrypt(String string) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.encryptAlgorithm);
            cipher.init(1, (Key)this.secretKey, this.parameterSpec);
            byte[] byArray = string.getBytes(this.encoding);
            byte[] byArray2 = cipher.doFinal(byArray);
            return ESAPI.encoder().encodeForBase64(byArray2, false);
        }
        catch (Exception exception) {
            throw new EncryptionException("Encryption failure", "Encryption problem: " + exception.getMessage(), exception);
        }
    }

    public String decrypt(String string) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.encryptAlgorithm);
            cipher.init(2, (Key)this.secretKey, this.parameterSpec);
            byte[] byArray = ESAPI.encoder().decodeFromBase64(string);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new String(byArray2, this.encoding);
        }
        catch (Exception exception) {
            throw new EncryptionException("Decryption failed", "Decryption problem: " + exception.getMessage(), exception);
        }
    }

    public String sign(String string) throws EncryptionException {
        String string2 = "SHAwithDSA";
        try {
            Signature signature = Signature.getInstance(string2);
            signature.initSign(this.privateKey);
            signature.update(string.getBytes());
            byte[] byArray = signature.sign();
            return ESAPI.encoder().encodeForBase64(byArray, true);
        }
        catch (Exception exception) {
            throw new EncryptionException("Signature failure", "Can't find signature algorithm " + string2, exception);
        }
    }

    public boolean verifySignature(String string, String string2) {
        try {
            byte[] byArray = ESAPI.encoder().decodeFromBase64(string);
            Signature signature = Signature.getInstance(this.signatureAlgorithm);
            signature.initVerify(this.publicKey);
            signature.update(string2.getBytes());
            return signature.verify(byArray);
        }
        catch (Exception exception) {
            new EncryptionException("Invalid signature", "Problem verifying signature: " + exception.getMessage(), exception);
            return false;
        }
    }

    public String seal(String string, long l) throws IntegrityException {
        try {
            String string2 = ESAPI.randomizer().getRandomString(10, DefaultEncoder.CHAR_ALPHANUMERICS);
            return this.encrypt(l + ":" + string2 + ":" + string);
        }
        catch (EncryptionException encryptionException) {
            throw new IntegrityException(encryptionException.getUserMessage(), encryptionException.getLogMessage(), encryptionException);
        }
    }

    public String unseal(String string) throws EncryptionException {
        long l;
        String string2 = null;
        try {
            string2 = this.decrypt(string);
        }
        catch (EncryptionException encryptionException) {
            throw new EncryptionException("Invalid seal", "Seal did not decrypt properly", encryptionException);
        }
        int n = string2.indexOf(":");
        if (n == -1) {
            throw new EncryptionException("Invalid seal", "Seal did not contain properly formatted separator");
        }
        String string3 = string2.substring(0, n);
        long l2 = new Date().getTime();
        if (l2 > (l = Long.parseLong(string3))) {
            throw new EncryptionException("Invalid seal", "Seal expiration date has expired");
        }
        n = string2.indexOf(":", n + 1);
        String string4 = string2.substring(n + 1);
        return string4;
    }

    public boolean verifySeal(String string) {
        try {
            this.unseal(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public long getTimeStamp() {
        return new Date().getTime();
    }

    public long getRelativeTimeStamp(long l) {
        return new Date().getTime() + l;
    }
}

