/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.owasp.esapi.AccessReferenceMap;
import org.owasp.esapi.errors.AccessControlException;

public class IntegerAccessReferenceMap
implements AccessReferenceMap {
    HashMap itod = new HashMap();
    HashMap dtoi = new HashMap();
    int count = 1;

    public IntegerAccessReferenceMap() {
    }

    public IntegerAccessReferenceMap(Set set) {
        this.update(set);
    }

    public Iterator iterator() {
        TreeSet treeSet = new TreeSet(this.dtoi.keySet());
        return treeSet.iterator();
    }

    public String addDirectReference(Object object) {
        if (this.dtoi.keySet().contains(object)) {
            return (String)this.dtoi.get(object);
        }
        String string = this.getUniqueReference();
        this.itod.put(string, object);
        this.dtoi.put(object, string);
        return string;
    }

    private synchronized String getUniqueReference() {
        return "" + this.count++;
    }

    public String removeDirectReference(Object object) throws AccessControlException {
        String string = (String)this.dtoi.get(object);
        if (string != null) {
            this.itod.remove(string);
            this.dtoi.remove(object);
        }
        return string;
    }

    public final void update(Set set) {
        HashMap hashMap = (HashMap)this.dtoi.clone();
        this.dtoi.clear();
        this.itod.clear();
        for (Object e : set) {
            String string = (String)hashMap.get(e);
            if (string == null) {
                string = this.getUniqueReference();
            }
            this.itod.put(string, e);
            this.dtoi.put(e, string);
        }
    }

    public String getIndirectReference(Object object) {
        return (String)this.dtoi.get(object);
    }

    public Object getDirectReference(String string) throws AccessControlException {
        if (this.itod.containsKey(string)) {
            return this.itod.get(string);
        }
        throw new AccessControlException("Access denied", "Request for invalid indirect reference: " + string);
    }
}

