/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.Authenticator;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.User;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.AuthenticationAccountsException;
import org.owasp.esapi.errors.AuthenticationCredentialsException;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.AuthenticationLoginException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.reference.DefaultEncoder;
import org.owasp.esapi.reference.DefaultUser;

public class FileBasedAuthenticator
implements Authenticator {
    protected static final String USER = "ESAPIUserSessionKey";
    private final Logger logger = ESAPI.getLogger("Authenticator");
    private File userDB = null;
    private long checkInterval = 60000L;
    private long lastModified = 0L;
    private long lastChecked = 0L;
    private final int MAX_ACCOUNT_NAME_LENGTH = 250;
    private Map userMap = new HashMap();
    private Map passwordMap = new Hashtable();
    private ThreadLocalUser currentUser = new ThreadLocalUser();

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            System.out.println("Usage: Authenticator accountname password role");
            return;
        }
        FileBasedAuthenticator fileBasedAuthenticator = new FileBasedAuthenticator();
        String string = stringArray[0].toLowerCase();
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        DefaultUser defaultUser = (DefaultUser)fileBasedAuthenticator.getUser(stringArray[0]);
        if (defaultUser == null) {
            defaultUser = new DefaultUser(string);
            String string4 = fileBasedAuthenticator.hashPassword(string2, string);
            fileBasedAuthenticator.setHashedPassword(defaultUser, string4);
            defaultUser.addRole(string3);
            defaultUser.enable();
            defaultUser.unlock();
            fileBasedAuthenticator.userMap.put(new Long(defaultUser.getAccountId()), defaultUser);
            System.out.println("New user created: " + string);
            fileBasedAuthenticator.saveUsers();
            System.out.println("User account " + defaultUser.getAccountName() + " updated");
        } else {
            System.err.println("User account " + defaultUser.getAccountName() + " already exists!");
        }
    }

    private void setHashedPassword(User user, String string) {
        List list = this.getAllHashedPasswords(user, true);
        list.add(0, string);
        if (list.size() > ESAPI.securityConfiguration().getMaxOldPasswordHashes()) {
            list.remove(list.size() - 1);
        }
        this.logger.info(Logger.SECURITY, true, "New hashed password stored for " + user.getAccountName());
    }

    String getHashedPassword(User user) {
        List list = this.getAllHashedPasswords(user, false);
        return (String)list.get(0);
    }

    void setOldPasswordHashes(User user, List list) {
        List list2 = this.getAllHashedPasswords(user, true);
        if (list2.size() > 1) {
            list2.removeAll(list2.subList(1, list2.size() - 1));
        }
        list2.addAll(list);
    }

    List getAllHashedPasswords(User user, boolean bl) {
        ArrayList arrayList = (ArrayList)this.passwordMap.get(user);
        if (arrayList != null) {
            return arrayList;
        }
        if (bl) {
            arrayList = new ArrayList();
            this.passwordMap.put(user, arrayList);
            return arrayList;
        }
        throw new RuntimeException("No hashes found for " + user.getAccountName() + ". Is User.hashcode() and equals() implemented correctly?");
    }

    List getOldPasswordHashes(User user) {
        List list = this.getAllHashedPasswords(user, false);
        if (list.size() > 1) {
            return Collections.unmodifiableList(list.subList(1, list.size() - 1));
        }
        return Collections.EMPTY_LIST;
    }

    public void clearCurrent() {
        this.currentUser.setUser(null);
    }

    public synchronized User createUser(String string, String string2, String string3) throws AuthenticationException {
        this.loadUsersIfNecessary();
        if (string == null) {
            throw new AuthenticationAccountsException("Account creation failed", "Attempt to create user with null accountName");
        }
        if (this.getUser(string) != null) {
            throw new AuthenticationAccountsException("Account creation failed", "Duplicate user creation denied for " + string);
        }
        this.verifyAccountNameStrength(string);
        if (string2 == null) {
            throw new AuthenticationCredentialsException("Invalid account name", "Attempt to create account " + string + " with a null password");
        }
        this.verifyPasswordStrength(null, string2);
        if (!string2.equals(string3)) {
            throw new AuthenticationCredentialsException("Passwords do not match", "Passwords for " + string + " do not match");
        }
        DefaultUser defaultUser = new DefaultUser(string);
        try {
            this.setHashedPassword(defaultUser, this.hashPassword(string2, string));
        }
        catch (EncryptionException encryptionException) {
            throw new AuthenticationException("Internal error", "Error hashing password for " + string, encryptionException);
        }
        this.userMap.put(new Long(defaultUser.getAccountId()), defaultUser);
        this.logger.info(Logger.SECURITY, true, "New user created: " + string);
        this.saveUsers();
        return defaultUser;
    }

    public boolean exists(String string) {
        return this.getUser(string) != null;
    }

    public String generateStrongPassword() {
        return this.generateStrongPassword("");
    }

    private String generateStrongPassword(String string) {
        Randomizer randomizer = ESAPI.randomizer();
        int n = randomizer.getRandomInteger(4, 6);
        int n2 = 7 - n;
        String string2 = randomizer.getRandomString(n, DefaultEncoder.CHAR_PASSWORD_LETTERS);
        String string3 = randomizer.getRandomString(n2, DefaultEncoder.CHAR_PASSWORD_DIGITS);
        String string4 = randomizer.getRandomString(1, DefaultEncoder.CHAR_PASSWORD_SPECIALS);
        String string5 = string2 + string4 + string3;
        return string5;
    }

    public void changePassword(User user, String string, String string2, String string3) throws AuthenticationException {
        String string4 = user.getAccountName();
        try {
            String string5 = this.getHashedPassword(user);
            String string6 = this.hashPassword(string, string4);
            if (!string5.equals(string6)) {
                throw new AuthenticationCredentialsException("Password change failed", "Authentication failed for password change on user: " + string4);
            }
            if (string2 == null || string3 == null || !string2.equals(string3)) {
                throw new AuthenticationCredentialsException("Password change failed", "Passwords do not match for password change on user: " + string4);
            }
            this.verifyPasswordStrength(string, string2);
            ((DefaultUser)user).setLastPasswordChangeTime(new Date());
            String string7 = this.hashPassword(string2, string4);
            if (this.getOldPasswordHashes(user).contains(string7)) {
                throw new AuthenticationCredentialsException("Password change failed", "Password change matches a recent password for user: " + string4);
            }
            this.setHashedPassword(user, string7);
            this.logger.info(Logger.SECURITY, true, "Password changed for user: " + string4);
        }
        catch (EncryptionException encryptionException) {
            throw new AuthenticationException("Password change failed", "Encryption exception changing password for " + string4, encryptionException);
        }
    }

    public boolean verifyPassword(User user, String string) {
        String string2 = user.getAccountName();
        try {
            String string3 = this.hashPassword(string, string2);
            String string4 = this.getHashedPassword(user);
            if (string3.equals(string4)) {
                ((DefaultUser)user).setLastLoginTime(new Date());
                ((DefaultUser)user).setFailedLoginCount(0);
                this.logger.info(Logger.SECURITY, true, "Password verified for " + string2);
                return true;
            }
        }
        catch (EncryptionException encryptionException) {
            this.logger.fatal(Logger.SECURITY, false, "Encryption error verifying password for " + string2);
        }
        this.logger.fatal(Logger.SECURITY, false, "Password verification failed for " + string2);
        return false;
    }

    public String generateStrongPassword(User user, String string) {
        String string2 = this.generateStrongPassword(string);
        if (string2 != null) {
            this.logger.info(Logger.SECURITY, true, "Generated strong password for " + user.getAccountName());
        }
        return string2;
    }

    public User getCurrentUser() {
        User user = (User)this.currentUser.get();
        if (user == null) {
            user = User.ANONYMOUS;
        }
        return user;
    }

    public synchronized User getUser(long l) {
        if (l == 0L) {
            return User.ANONYMOUS;
        }
        this.loadUsersIfNecessary();
        User user = (User)this.userMap.get(new Long(l));
        return user;
    }

    public synchronized User getUser(String string) {
        if (string == null) {
            return User.ANONYMOUS;
        }
        this.loadUsersIfNecessary();
        for (User user : this.userMap.values()) {
            if (!user.getAccountName().equalsIgnoreCase(string)) continue;
            return user;
        }
        return null;
    }

    protected User getUserFromSession() {
        HttpSession httpSession = ESAPI.httpUtilities().getCurrentRequest().getSession(false);
        if (httpSession == null) {
            return null;
        }
        return (User)httpSession.getAttribute(USER);
    }

    protected DefaultUser getUserFromRememberToken() {
        Cookie cookie = ESAPI.httpUtilities().getCookie(ESAPI.currentRequest(), "ESAPIRememberToken");
        if (cookie == null) {
            return null;
        }
        String[] stringArray = null;
        try {
            stringArray = ESAPI.encryptor().unseal(cookie.getValue()).split(":");
        }
        catch (EncryptionException encryptionException) {
            this.logger.warning(Logger.SECURITY, false, "Found corrupt or expired remember token");
            ESAPI.httpUtilities().killCookie(ESAPI.currentRequest(), ESAPI.currentResponse(), "ESAPIRememberToken");
            return null;
        }
        if (stringArray.length != 3) {
            return null;
        }
        String string = stringArray[1];
        String string2 = stringArray[2];
        DefaultUser defaultUser = (DefaultUser)this.getUser(string);
        if (defaultUser == null) {
            this.logger.warning(Logger.SECURITY, false, "Found valid remember token but no user matching " + string);
            return null;
        }
        this.logger.warning(Logger.SECURITY, true, "Logging in user with remember token: " + defaultUser.getAccountName());
        try {
            defaultUser.loginWithPassword(string2);
        }
        catch (AuthenticationException authenticationException) {
            this.logger.warning(Logger.SECURITY, false, "Login via remember me cookie failed for user " + string, authenticationException);
            ESAPI.httpUtilities().killCookie(ESAPI.currentRequest(), ESAPI.currentResponse(), "ESAPIRememberToken");
            return null;
        }
        return defaultUser;
    }

    public synchronized Set getUserNames() {
        this.loadUsersIfNecessary();
        HashSet<String> hashSet = new HashSet<String>();
        for (User user : this.userMap.values()) {
            hashSet.add(user.getAccountName());
        }
        return hashSet;
    }

    public String hashPassword(String string, String string2) throws EncryptionException {
        String string3 = string2.toLowerCase();
        return ESAPI.encryptor().hash(string, string3);
    }

    protected void loadUsersIfNecessary() {
        long l;
        if (this.userDB == null) {
            this.userDB = new File(ESAPI.securityConfiguration().getResourceDirectory(), "users.txt");
        }
        if ((l = System.currentTimeMillis()) - this.lastChecked < this.checkInterval) {
            return;
        }
        this.lastChecked = l;
        if (this.lastModified == this.userDB.lastModified()) {
            return;
        }
        this.loadUsersImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadUsersImmediately() {
        FileBasedAuthenticator fileBasedAuthenticator = this;
        synchronized (fileBasedAuthenticator) {
            this.logger.trace(Logger.SECURITY, true, "Loading users from " + this.userDB.getAbsolutePath(), null);
            BufferedReader bufferedReader = null;
            try {
                HashMap<Long, DefaultUser> hashMap = new HashMap<Long, DefaultUser>();
                bufferedReader = new BufferedReader(new FileReader(this.userDB));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.length() <= 0 || string.charAt(0) == '#') continue;
                    DefaultUser defaultUser = this.createUser(string);
                    if (hashMap.containsKey(new Long(defaultUser.getAccountId()))) {
                        this.logger.fatal(Logger.SECURITY, false, "Problem in user file. Skipping duplicate user: " + defaultUser, null);
                    }
                    hashMap.put(new Long(defaultUser.getAccountId()), defaultUser);
                }
                this.userMap = hashMap;
                this.lastModified = System.currentTimeMillis();
                this.logger.trace(Logger.SECURITY, true, "User file reloaded: " + hashMap.size(), null);
            }
            catch (Exception exception) {
                this.logger.fatal(Logger.SECURITY, false, "Failure loading user file: " + this.userDB.getAbsolutePath(), exception);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    this.logger.fatal(Logger.SECURITY, false, "Failure closing user file: " + this.userDB.getAbsolutePath(), iOException);
                }
            }
        }
    }

    private DefaultUser createUser(String string) throws AuthenticationException {
        String[] stringArray = string.split(" *\\| *");
        String string2 = stringArray[0];
        long l = Long.parseLong(string2);
        String string3 = stringArray[1];
        this.verifyAccountNameStrength(string3);
        DefaultUser defaultUser = new DefaultUser(string3);
        defaultUser.accountId = l;
        String string4 = stringArray[2];
        this.verifyPasswordStrength(null, string4);
        this.setHashedPassword(defaultUser, string4);
        String[] stringArray2 = stringArray[3].toLowerCase().split(" *, *");
        for (int i = 0; i < stringArray2.length; ++i) {
            if ("".equals(stringArray2[i])) continue;
            defaultUser.addRole(stringArray2[i]);
        }
        if (!"unlocked".equalsIgnoreCase(stringArray[4])) {
            defaultUser.lock();
        }
        if ("enabled".equalsIgnoreCase(stringArray[5])) {
            defaultUser.enable();
        } else {
            defaultUser.disable();
        }
        defaultUser.resetCSRFToken();
        this.setOldPasswordHashes(defaultUser, Arrays.asList(stringArray[6].split(" *, *")));
        defaultUser.setLastHostAddress("null".equals(stringArray[7]) ? null : stringArray[7]);
        defaultUser.setLastPasswordChangeTime(new Date(Long.parseLong(stringArray[8])));
        defaultUser.setLastLoginTime(new Date(Long.parseLong(stringArray[9])));
        defaultUser.setLastFailedLoginTime(new Date(Long.parseLong(stringArray[10])));
        defaultUser.setExpirationTime(new Date(Long.parseLong(stringArray[11])));
        defaultUser.setFailedLoginCount(Integer.parseInt(stringArray[12]));
        return defaultUser;
    }

    private User loginWithUsernameAndPassword(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws AuthenticationException {
        String string = httpServletRequest.getParameter(ESAPI.securityConfiguration().getUsernameParameterName());
        String string2 = httpServletRequest.getParameter(ESAPI.securityConfiguration().getPasswordParameterName());
        User user = this.getCurrentUser();
        if (user != null && !user.isAnonymous()) {
            this.logger.warning(Logger.SECURITY, true, "User requested relogin. Performing logout then authentication");
            user.logout();
        }
        if (string == null || string2 == null) {
            if (string == null) {
                string = "unspecified user";
            }
            throw new AuthenticationCredentialsException("Authentication failed", "Authentication failed for " + string + " because of null username or password");
        }
        user = this.getUser(string);
        if (user == null) {
            throw new AuthenticationCredentialsException("Authentication failed", "Authentication failed because user " + string + " doesn't exist");
        }
        user.loginWithPassword(string2);
        httpServletRequest.setAttribute(user.getCSRFToken(), (Object)"authenticated");
        return user;
    }

    public synchronized void removeUser(String string) throws AuthenticationException {
        this.loadUsersIfNecessary();
        User user = this.getUser(string);
        if (user == null) {
            throw new AuthenticationAccountsException("Remove user failed", "Can't remove invalid accountName " + string);
        }
        this.userMap.remove(new Long(user.getAccountId()));
        System.out.println("Removing user " + user.getAccountName());
        this.passwordMap.remove(user.getAccountName());
        this.saveUsers();
    }

    public synchronized void saveUsers() throws AuthenticationException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(this.userDB));
            printWriter.println("# This is the user file associated with the ESAPI library from http://www.owasp.org");
            printWriter.println("# accountId | accountName | hashedPassword | roles | locked | enabled | csrfToken | oldPasswordHashes | lastPasswordChangeTime | lastLoginTime | lastFailedLoginTime | expirationTime | failedLoginCount");
            printWriter.println();
            this.saveUsers(printWriter);
            printWriter.flush();
            this.logger.info(Logger.SECURITY, true, "User file written to disk");
        }
        catch (IOException iOException) {
            this.logger.fatal(Logger.SECURITY, false, "Problem saving user file " + this.userDB.getAbsolutePath(), iOException);
            throw new AuthenticationException("Internal Error", "Problem saving user file " + this.userDB.getAbsolutePath(), iOException);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                this.lastChecked = this.lastModified = this.userDB.lastModified();
            }
        }
    }

    protected synchronized void saveUsers(PrintWriter printWriter) {
        for (String string : this.getUserNames()) {
            DefaultUser defaultUser = (DefaultUser)this.getUser(string);
            if (defaultUser != null && !defaultUser.isAnonymous()) {
                printWriter.println(this.save(defaultUser));
                continue;
            }
            new AuthenticationCredentialsException("Problem saving user", "Skipping save of user " + string);
        }
    }

    private String save(DefaultUser defaultUser) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(defaultUser.getAccountId());
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.getAccountName());
        stringBuffer.append(" | ");
        stringBuffer.append(this.getHashedPassword(defaultUser));
        stringBuffer.append(" | ");
        stringBuffer.append(this.dump(defaultUser.getRoles()));
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.isLocked() ? "locked" : "unlocked");
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.isEnabled() ? "enabled" : "disabled");
        stringBuffer.append(" | ");
        stringBuffer.append(this.dump(this.getOldPasswordHashes(defaultUser)));
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.getLastHostAddress());
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.getLastPasswordChangeTime().getTime());
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.getLastLoginTime().getTime());
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.getLastFailedLoginTime().getTime());
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.getExpirationTime().getTime());
        stringBuffer.append(" | ");
        stringBuffer.append(defaultUser.getFailedLoginCount());
        return stringBuffer.toString();
    }

    private String dump(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public User login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws AuthenticationException {
        if (httpServletRequest == null || httpServletResponse == null) {
            throw new AuthenticationCredentialsException("Invalid request", "Request or response objects were null");
        }
        DefaultUser defaultUser = (DefaultUser)this.getUserFromSession();
        if (defaultUser == null) {
            defaultUser = this.getUserFromRememberToken();
        }
        if (defaultUser == null) {
            defaultUser = (DefaultUser)this.loginWithUsernameAndPassword(httpServletRequest, httpServletResponse);
        }
        defaultUser.setLastHostAddress(httpServletRequest.getRemoteHost());
        try {
            ESAPI.httpUtilities().assertSecureRequest(ESAPI.currentRequest());
        }
        catch (AccessControlException accessControlException) {
            throw new AuthenticationException("Attempt to login with an insecure request", accessControlException.getLogMessage(), accessControlException);
        }
        if (defaultUser.isAnonymous()) {
            defaultUser.logout();
            throw new AuthenticationLoginException("Login failed", "Anonymous user cannot be set to current user. User: " + defaultUser.getAccountName());
        }
        if (!defaultUser.isEnabled()) {
            defaultUser.logout();
            defaultUser.incrementFailedLoginCount();
            defaultUser.setLastFailedLoginTime(new Date());
            throw new AuthenticationLoginException("Login failed", "Disabled user cannot be set to current user. User: " + defaultUser.getAccountName());
        }
        if (defaultUser.isLocked()) {
            defaultUser.logout();
            defaultUser.incrementFailedLoginCount();
            defaultUser.setLastFailedLoginTime(new Date());
            throw new AuthenticationLoginException("Login failed", "Locked user cannot be set to current user. User: " + defaultUser.getAccountName());
        }
        if (defaultUser.isExpired()) {
            defaultUser.logout();
            defaultUser.incrementFailedLoginCount();
            defaultUser.setLastFailedLoginTime(new Date());
            throw new AuthenticationLoginException("Login failed", "Expired user cannot be set to current user. User: " + defaultUser.getAccountName());
        }
        if (defaultUser.isSessionTimeout()) {
            defaultUser.logout();
            defaultUser.incrementFailedLoginCount();
            defaultUser.setLastFailedLoginTime(new Date());
            throw new AuthenticationLoginException("Login failed", "Session inactivity timeout: " + defaultUser.getAccountName());
        }
        if (defaultUser.isSessionAbsoluteTimeout()) {
            defaultUser.logout();
            defaultUser.incrementFailedLoginCount();
            defaultUser.setLastFailedLoginTime(new Date());
            throw new AuthenticationLoginException("Login failed", "Session absolute timeout: " + defaultUser.getAccountName());
        }
        HttpSession httpSession = httpServletRequest.getSession();
        defaultUser.addSession(httpSession);
        httpSession.setAttribute(USER, (Object)defaultUser);
        this.setCurrentUser(defaultUser);
        return defaultUser;
    }

    public void logout() {
        User user = this.getCurrentUser();
        if (user != null && !user.isAnonymous()) {
            user.logout();
        }
    }

    public void setCurrentUser(User user) {
        this.currentUser.setUser(user);
    }

    public void verifyAccountNameStrength(String string) throws AuthenticationException {
        if (string == null) {
            throw new AuthenticationCredentialsException("Invalid account name", "Attempt to create account with a null account name");
        }
        if (!ESAPI.validator().isValidInput("verifyAccountNameStrength", string, "AccountName", 250, false)) {
            throw new AuthenticationCredentialsException("Invalid account name", "New account name is not valid: " + string);
        }
    }

    public void verifyPasswordStrength(String string, String string2) throws AuthenticationException {
        int n;
        int n2;
        if (string2 == null) {
            throw new AuthenticationCredentialsException("Invalid password", "New password cannot be null");
        }
        if (string != null) {
            n2 = string.length();
            for (n = 0; n < n2 - 2; ++n) {
                String string3 = string.substring(n, n + 3);
                if (string2.indexOf(string3) <= -1) continue;
                throw new AuthenticationCredentialsException("Invalid password", "New password cannot contain pieces of old password");
            }
        }
        n2 = 0;
        for (n = 0; n < string2.length(); ++n) {
            if (Arrays.binarySearch(DefaultEncoder.CHAR_LOWERS, string2.charAt(n)) <= 0) continue;
            ++n2;
            break;
        }
        for (n = 0; n < string2.length(); ++n) {
            if (Arrays.binarySearch(DefaultEncoder.CHAR_UPPERS, string2.charAt(n)) <= 0) continue;
            ++n2;
            break;
        }
        for (n = 0; n < string2.length(); ++n) {
            if (Arrays.binarySearch(DefaultEncoder.CHAR_DIGITS, string2.charAt(n)) <= 0) continue;
            ++n2;
            break;
        }
        for (n = 0; n < string2.length(); ++n) {
            if (Arrays.binarySearch(DefaultEncoder.CHAR_SPECIALS, string2.charAt(n)) <= 0) continue;
            ++n2;
            break;
        }
        if ((n = string2.length() * n2) < 16) {
            throw new AuthenticationCredentialsException("Invalid password", "New password is not long and complex enough");
        }
    }

    private class ThreadLocalUser
    extends InheritableThreadLocal {
        private ThreadLocalUser() {
        }

        public Object initialValue() {
            return User.ANONYMOUS;
        }

        public User getUser() {
            return (User)super.get();
        }

        public void setUser(User user) {
            super.set(user);
        }
    }
}

