/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.owasp.esapi.AccessController;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.IntrusionException;

public class FileBasedAccessController
implements AccessController {
    private Map urlMap = new HashMap();
    private Map functionMap = new HashMap();
    private Map dataMap = new HashMap();
    private Map fileMap = new HashMap();
    private Map serviceMap = new HashMap();
    private Rule deny = new Rule();
    private Logger logger = ESAPI.getLogger("AccessController");

    public boolean isAuthorizedForURL(String string) {
        try {
            this.assertAuthorizedForURL(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isAuthorizedForFunction(String string) {
        try {
            this.assertAuthorizedForFunction(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isAuthorizedForData(String string) {
        try {
            this.assertAuthorizedForData(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isAuthorizedForData(String string, Object object) {
        try {
            this.assertAuthorizedForData(string, object);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isAuthorizedForFile(String string) {
        try {
            this.assertAuthorizedForFile(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isAuthorizedForService(String string) {
        try {
            this.assertAuthorizedForService(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void assertAuthorizedForURL(String string) throws AccessControlException {
        if (this.urlMap == null || this.urlMap.isEmpty()) {
            this.urlMap = this.loadRules("URLAccessRules.txt");
        }
        if (!this.matchRule(this.urlMap, string)) {
            throw new AccessControlException("Not authorized for URL", "Not authorized for URL: " + string);
        }
    }

    public void assertAuthorizedForFunction(String string) throws AccessControlException {
        if (this.functionMap == null || this.functionMap.isEmpty()) {
            this.functionMap = this.loadRules("FunctionAccessRules.txt");
        }
        if (!this.matchRule(this.functionMap, string)) {
            throw new AccessControlException("Not authorized for function", "Not authorized for function: " + string);
        }
    }

    public void assertAuthorizedForData(String string) throws AccessControlException {
        if (this.dataMap == null || this.dataMap.isEmpty()) {
            this.dataMap = this.loadDataRules("DataAccessRules.txt");
        }
        if (!this.matchRule(this.dataMap, string)) {
            throw new AccessControlException("Not authorized for function", "Not authorized for data: " + string);
        }
    }

    public void assertAuthorizedForData(String string, Object object) throws AccessControlException {
        if (this.dataMap == null || this.dataMap.isEmpty()) {
            this.dataMap = this.loadDataRules("DataAccessRules.txt");
        }
        if (!this.matchRule(this.dataMap, (Class)object, string)) {
            throw new AccessControlException("Not authorized for data", "Not authorized for data: " + (Class)object);
        }
    }

    public void assertAuthorizedForFile(String string) throws AccessControlException {
        if (this.fileMap == null || this.fileMap.isEmpty()) {
            this.fileMap = this.loadRules("FileAccessRules.txt");
        }
        if (!this.matchRule(this.fileMap, string.replaceAll("\\\\", "/"))) {
            throw new AccessControlException("Not authorized for file", "Not authorized for file: " + string);
        }
    }

    public void assertAuthorizedForService(String string) throws AccessControlException {
        if (this.serviceMap == null || this.serviceMap.isEmpty()) {
            this.serviceMap = this.loadRules("ServiceAccessRules.txt");
        }
        if (!this.matchRule(this.serviceMap, string)) {
            throw new AccessControlException("Not authorized for service", "Not authorized for service: " + string);
        }
    }

    private boolean matchRule(Map map, String string) {
        User user = ESAPI.authenticator().getCurrentUser();
        Set set = user.getRoles();
        Rule rule = this.searchForRule(map, set, string);
        return rule.allow;
    }

    private boolean matchRule(Map map, Class clazz, String string) {
        User user = ESAPI.authenticator().getCurrentUser();
        Set set = user.getRoles();
        Rule rule = this.searchForRule(map, set, clazz, string);
        return rule != null;
    }

    private Rule searchForRule(Map map, Set set, String string) {
        Rule rule;
        String string2 = null;
        try {
            string2 = ESAPI.encoder().canonicalize(string);
        }
        catch (EncodingException encodingException) {
            this.logger.warning(Logger.SECURITY, false, "Failed to canonicalize input: " + string);
        }
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        while (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string3.indexOf("..") != -1) {
            throw new IntrusionException("Attempt to manipulate access control path", "Attempt to manipulate access control path: " + string);
        }
        String string4 = "";
        int n = string3.lastIndexOf(".");
        if (n != -1) {
            string4 = string3.substring(n + 1);
        }
        if ((rule = (Rule)map.get(string3)) == null) {
            rule = (Rule)map.get(string3 + "/*");
        }
        if (rule == null) {
            rule = (Rule)map.get("*." + string4);
        }
        if (rule != null && this.overlap(rule.roles, set)) {
            return rule;
        }
        int n2 = string3.lastIndexOf(47);
        if (n2 == -1) {
            return this.deny;
        }
        if ((string3 = string3.substring(0, string3.lastIndexOf(47))).length() <= 1) {
            return this.deny;
        }
        return this.searchForRule(map, set, string3);
    }

    private Rule searchForRule(Map map, Set set, Class clazz, String string) {
        Rule rule = (Rule)map.get(clazz);
        if (rule != null && this.overlap(rule.actions, string) && this.overlap(rule.roles, set)) {
            return rule;
        }
        return null;
    }

    private boolean overlap(Set set, Set set2) {
        if (set.contains("any")) {
            return true;
        }
        for (String string : set2) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean overlap(List list, String string) {
        return list.contains(string);
    }

    private List validateRoles(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = "";
            try {
                string = ESAPI.encoder().canonicalize(((String)list.get(i)).trim());
            }
            catch (EncodingException encodingException) {
                this.logger.warning(Logger.SECURITY, false, "Failed to canonicalize role " + ((String)list.get(i)).trim(), encodingException);
            }
            if (!ESAPI.validator().isValidInput("Validating user roles in FileBasedAccessController", string, "^[a-zA-Z0-9_]{0,10}$", 200, false)) {
                this.logger.warning(Logger.SECURITY, false, "Role: " + ((String)list.get(i)).trim() + " is invalid, so was not added to the list of roles for this Rule.");
                continue;
            }
            arrayList.add(string.trim());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadRules(String string) {
        HashMap<String, Rule> hashMap = new HashMap<String, Rule>();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(ESAPI.securityConfiguration().getResourceDirectory(), string));
            String string2 = "";
            while ((string2 = ESAPI.validator().safeReadLine(inputStream, 500)) != null) {
                if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                Rule rule = new Rule();
                String[] stringArray = string2.split("\\|");
                rule.path = stringArray[0].trim().replaceAll("\\\\", "/");
                List list = this.commaSplit(stringArray[1].trim().toLowerCase());
                list = this.validateRoles(list);
                for (int i = 0; i < list.size(); ++i) {
                    rule.roles.add(((String)list.get(i)).trim());
                }
                String string3 = stringArray[2].trim();
                rule.allow = string3.equalsIgnoreCase("allow");
                if (hashMap.containsKey(rule.path)) {
                    this.logger.warning(Logger.SECURITY, false, "Problem in access control file. Duplicate rule ignored: " + rule);
                    continue;
                }
                hashMap.put(rule.path, rule);
            }
        }
        catch (Exception exception) {
            this.logger.warning(Logger.SECURITY, false, "Problem in access control file : " + string, exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.logger.warning(Logger.SECURITY, false, "Failure closing access control file : " + string, iOException);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadDataRules(String string) {
        HashMap<Class, Rule> hashMap = new HashMap<Class, Rule>();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(ESAPI.securityConfiguration().getResourceDirectory(), string));
            String string2 = "";
            while ((string2 = ESAPI.validator().safeReadLine(inputStream, 500)) != null) {
                if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                Rule rule = new Rule();
                String[] stringArray = string2.split("\\|");
                rule.clazz = Class.forName(stringArray[0].trim());
                List list = this.commaSplit(stringArray[1].trim().toLowerCase());
                list = this.validateRoles(list);
                for (int i = 0; i < list.size(); ++i) {
                    rule.roles.add(((String)list.get(i)).trim());
                }
                List list2 = this.commaSplit(stringArray[2].trim().toLowerCase());
                for (int i = 0; i < list2.size(); ++i) {
                    rule.actions.add(((String)list2.get(i)).trim());
                }
                if (hashMap.containsKey(rule.path)) {
                    this.logger.warning(Logger.SECURITY, false, "Problem in access control file. Duplicate rule ignored: " + rule);
                    continue;
                }
                hashMap.put(rule.clazz, rule);
            }
        }
        catch (Exception exception) {
            this.logger.warning(Logger.SECURITY, false, "Problem in access control file : " + string, exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.logger.warning(Logger.SECURITY, false, "Failure closing access control file : " + string, iOException);
            }
        }
        return hashMap;
    }

    private List commaSplit(String string) {
        String[] stringArray = string.split(",");
        return Arrays.asList(stringArray);
    }

    private class Rule {
        protected String path = "";
        protected Set roles = new HashSet();
        protected boolean allow = false;
        protected Class clazz = null;
        protected List actions = new ArrayList();

        protected Rule() {
        }

        public String toString() {
            return "URL:" + this.path + " | " + this.roles + " | " + (this.allow ? "allow" : "deny");
        }
    }
}

