/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationAvailabilityException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.filters.SafeRequest;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class DefaultValidator
implements Validator {
    private Policy antiSamyPolicy = null;
    private static final int MAX_CREDIT_CARD_LENGTH = 19;
    private static final int MAX_PARAMETER_NAME_LENGTH = 100;
    private static final int MAX_PARAMETER_VALUE_LENGTH = 65535;

    public boolean isValidInput(String string, String string2, String string3, int n, boolean bl) throws IntrusionException {
        try {
            this.getValidInput(string, string2, string3, n, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getValidInput(String string, String string2, String string3, int n, boolean bl) throws ValidationException, IntrusionException {
        try {
            string = ESAPI.encoder().canonicalize(string);
            String string4 = ESAPI.encoder().canonicalize(string2);
            if (string3 == null || string3.length() == 0) {
                throw new RuntimeException("Validation misconfiguration, specified type to validate against was null: context=" + string + ", type=" + string3 + "), input=" + string2);
            }
            if (this.isEmpty(string4)) {
                if (bl) {
                    return null;
                }
                throw new ValidationException(string + ": Input required.", "Input required: context=" + string + ", type=" + string3 + "), input=" + string2, string);
            }
            if (string4.length() > n) {
                throw new ValidationException(string + ": Invalid input. The maximum length of " + n + " characters was exceeded.", "Input exceeds maximum allowed length of " + n + " by " + (string4.length() - n) + " characters: context=" + string + ", type=" + string3 + "), input=" + string2, string);
            }
            Pattern pattern = ((DefaultSecurityConfiguration)ESAPI.securityConfiguration()).getValidationPattern(string3);
            if (pattern == null) {
                try {
                    pattern = Pattern.compile(string3);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new RuntimeException("Validation misconfiguration, specified type to validate against was null: context=" + string + ", type=" + string3 + "), input=" + string2);
                }
            }
            if (!pattern.matcher(string4).matches()) {
                throw new ValidationException(string + ": Invalid input. Please conform to: " + pattern.pattern() + " with a maximum length of " + n, "Invalid input: context=" + string + ", type=" + string3 + "( " + pattern.pattern() + "), input=" + string2, string);
            }
            return string4;
        }
        catch (EncodingException encodingException) {
            throw new ValidationException(string + ": Invalid input. An encoding error occurred.", "Error canonicalizing user input", encodingException, string);
        }
    }

    public String getValidInput(String string, String string2, String string3, int n, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidInput(string, string2, string3, n, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public boolean isValidDate(String string, String string2, DateFormat dateFormat, boolean bl) throws IntrusionException {
        try {
            this.getValidDate(string, string2, dateFormat, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Date getValidDate(String string, String string2, DateFormat dateFormat, boolean bl) throws ValidationException, IntrusionException {
        try {
            if (this.isEmpty(string2)) {
                if (bl) {
                    return null;
                }
                throw new ValidationException(string + ": Input date required", "Input date required: context=" + string + ", input=" + string2, string);
            }
            Date date = dateFormat.parse(string2);
            return date;
        }
        catch (Exception exception) {
            throw new ValidationException(string + ": Invalid date must follow " + dateFormat + " format", "Invalid date: context=" + string + ", format=" + dateFormat + ", input=" + string2, exception, string);
        }
    }

    public Date getValidDate(String string, String string2, DateFormat dateFormat, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidDate(string, string2, dateFormat, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSafeHTML(String string, String string2, int n, boolean bl) throws IntrusionException {
        try {
            Object object;
            Object object2;
            if (this.antiSamyPolicy == null) {
                if (ESAPI.securityConfiguration().getResourceDirectory() == null) {
                    object2 = this.getClass().getClassLoader();
                    object = null;
                    try {
                        object = ((ClassLoader)object2).getResourceAsStream("antisamy-esapi.xml");
                        if (object != null) {
                            this.antiSamyPolicy = Policy.getInstance((InputStream)object);
                        }
                    }
                    catch (Exception exception) {
                        this.antiSamyPolicy = null;
                    }
                    finally {
                        if (object != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (this.antiSamyPolicy == null) {
                        throw new IllegalArgumentException("Can't load antisamy-esapi.xml as a classloader resource");
                    }
                } else {
                    this.antiSamyPolicy = Policy.getInstance((String)(ESAPI.securityConfiguration().getResourceDirectory() + "antisamy-esapi.xml"));
                }
            }
            return (object = (object2 = new AntiSamy()).scan(string2, this.antiSamyPolicy)).getErrorMessages().size() == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValidSafeHTML(String string, String string2, int n, boolean bl) throws ValidationException, IntrusionException {
        if (this.isEmpty(string2)) {
            if (bl) {
                return null;
            }
            throw new ValidationException(string + ": Input HTML required", "Input HTML required: context=" + string + ", input=" + string2, string);
        }
        if (string2.length() > n) {
            throw new ValidationException(string + ": Invalid HTML. You enterted " + string2.length() + " characters. Input can not exceed " + n + " characters.", string + " input exceedes maxLength by " + (string2.length() - n) + " characters", string);
        }
        try {
            ArrayList arrayList;
            Object object;
            Object object2;
            if (this.antiSamyPolicy == null) {
                if (ESAPI.securityConfiguration().getResourceDirectory() == null) {
                    object2 = this.getClass().getClassLoader();
                    object = null;
                    try {
                        object = ((ClassLoader)object2).getResourceAsStream("antisamy-esapi.xml");
                        if (object != null) {
                            this.antiSamyPolicy = Policy.getInstance((InputStream)object);
                        }
                    }
                    catch (Exception exception) {
                        this.antiSamyPolicy = null;
                    }
                    finally {
                        if (object != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (this.antiSamyPolicy == null) {
                        throw new IllegalArgumentException("Can't load antisamy-esapi.xml as a classloader resource");
                    }
                } else {
                    this.antiSamyPolicy = Policy.getInstance((String)(ESAPI.securityConfiguration().getResourceDirectory() + "antisamy-esapi.xml"));
                }
            }
            if ((arrayList = (object = (object2 = new AntiSamy()).scan(string2, this.antiSamyPolicy)).getErrorMessages()).size() > 0) {
                new ValidationException("Invalid HTML input: context=" + string, "Invalid HTML input: context=" + string + ", errors=" + arrayList, string);
            }
            return object.getCleanHTML().trim();
        }
        catch (ScanException scanException) {
            throw new ValidationException(string + ": Invalid HTML input", "Invalid HTML input: context=" + string + " error=" + scanException.getMessage(), scanException, string);
        }
        catch (PolicyException policyException) {
            throw new ValidationException(string + ": Invalid HTML input", "Invalid HTML input does not follow rules in antisamy-esapi.xml: context=" + string + " error=" + policyException.getMessage(), policyException, string);
        }
    }

    public String getValidSafeHTML(String string, String string2, int n, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidSafeHTML(string, string2, n, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public boolean isValidCreditCard(String string, String string2, boolean bl) throws IntrusionException {
        try {
            this.getValidCreditCard(string, string2, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getValidCreditCard(String string, String string2, boolean bl) throws ValidationException, IntrusionException {
        int n;
        int n2;
        if (this.isEmpty(string2)) {
            if (bl) {
                return null;
            }
            throw new ValidationException(string + ": Input credit card required", "Input credit card required: context=" + string + ", input=" + string2, string);
        }
        String string3 = this.getValidInput(string, string2, "CreditCard", 19, bl);
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < string3.length(); ++n2) {
            char c = string3.charAt(n2);
            if (!Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        for (n = stringBuffer.length() - 1; n >= 0; --n) {
            n3 = Integer.parseInt(stringBuffer.substring(n, n + 1));
            if (bl2) {
                n4 = n3 * 2;
                if (n4 > 9) {
                    n4 -= 9;
                }
            } else {
                n4 = n3;
            }
            n2 += n4;
            bl2 = !bl2;
        }
        n = n2 % 10;
        if (n != 0) {
            throw new ValidationException(string + ": Invalid credit card input", "Invalid credit card input: context=" + string, string);
        }
        return string3;
    }

    public String getValidCreditCard(String string, String string2, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidCreditCard(string, string2, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public boolean isValidDirectoryPath(String string, String string2, boolean bl) throws IntrusionException {
        try {
            this.getValidDirectoryPath(string, string2, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getValidDirectoryPath(String string, String string2, boolean bl) throws ValidationException, IntrusionException {
        try {
            String string3;
            if (this.isEmpty(string2)) {
                if (bl) {
                    return null;
                }
                throw new ValidationException(string + ": Input directory path required", "Input directory path required: context=" + string + ", input=" + string2, string);
            }
            String string4 = this.getValidInput(string, string2, "DirectoryName", 255, false);
            String string5 = new File(string4).getCanonicalPath().replaceAll("\\\\", "/");
            String string6 = string5.toLowerCase();
            if (string6.length() >= 2 && string6.charAt(0) >= 'a' && string6.charAt(0) <= 'z' && string6.charAt(1) == ':') {
                string5 = string5.substring(2);
            }
            if ((string6 = (string3 = string4.replaceAll("\\\\", "/")).toLowerCase()).length() >= 2 && string6.charAt(0) >= 'a' && string6.charAt(0) <= 'z' && string6.charAt(1) == ':') {
                string3 = string3.substring(2);
            }
            if (!string3.equals(string5.toLowerCase())) {
                throw new ValidationException(string + ": Invalid directory name", "Invalid directory name does not match the canonical path: context=" + string + ", input=" + string2 + ", canonical=" + string4, string);
            }
            return string4;
        }
        catch (IOException iOException) {
            throw new ValidationException(string + ": Invalid directory name", "Invalid directory name does not exist: context=" + string + ", input=" + string2, iOException, string);
        }
    }

    public String getValidDirectoryPath(String string, String string2, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidDirectoryPath(string, string2, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public boolean isValidFileName(String string, String string2, boolean bl) throws IntrusionException {
        try {
            this.getValidFileName(string, string2, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getValidFileName(String string, String string2, boolean bl) throws ValidationException, IntrusionException {
        String string3;
        Object object;
        Object object2;
        String string4 = "";
        try {
            if (this.isEmpty(string2)) {
                if (bl) {
                    return null;
                }
                throw new ValidationException(string + ": Input file name required", "Input required: context=" + string + ", input=" + string2, string);
            }
            string4 = ESAPI.encoder().canonicalize(string2);
            this.getValidInput(string, string2, "FileName", 255, true);
            object2 = new File(string4);
            object = ((File)object2).getCanonicalPath();
            string3 = ((String)object).substring(((String)object).lastIndexOf(File.separator) + 1);
            if (!string2.equals(string3.toLowerCase())) {
                throw new ValidationException(string + ": Invalid file name", "Invalid directory name does not match the canonical path: context=" + string + ", input=" + string2 + ", canonical=" + string4, string);
            }
        }
        catch (IOException iOException) {
            throw new ValidationException(string + ": Invalid file name", "Invalid file name does not exist: context=" + string + ", canonical=" + string4, iOException, string);
        }
        catch (EncodingException encodingException) {
            throw new IntrusionException(string + ": Invalid file name", "Invalid file name: context=" + string + ", canonical=" + string4, encodingException);
        }
        object2 = ESAPI.securityConfiguration().getAllowedFileExtensions();
        object = object2.iterator();
        while (object.hasNext()) {
            string3 = (String)object.next();
            if (!string2.toLowerCase().endsWith(string3.toLowerCase())) continue;
            return string4;
        }
        throw new ValidationException(string + ": Invalid file name does not have valid extension ( " + ESAPI.securityConfiguration().getAllowedFileExtensions() + ")", "Invalid file name does not have valid extension ( " + ESAPI.securityConfiguration().getAllowedFileExtensions() + "): context=" + string + ", input=" + string2, string);
    }

    public String getValidFileName(String string, String string2, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidFileName(string, string2, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public boolean isValidNumber(String string, String string2, long l, long l2, boolean bl) throws IntrusionException {
        try {
            this.getValidNumber(string, string2, l, l2, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Double getValidNumber(String string, String string2, long l, long l2, boolean bl) throws ValidationException, IntrusionException {
        Double d = new Double(l);
        Double d2 = new Double(l2);
        return this.getValidDouble(string, string2, d, d2, bl);
    }

    public Double getValidNumber(String string, String string2, long l, long l2, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidNumber(string, string2, l, l2, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return new Double(0.0);
        }
    }

    public boolean isValidDouble(String string, String string2, double d, double d2, boolean bl) throws IntrusionException {
        return this.isValidDouble(string, string2, d, d2, bl);
    }

    public Double getValidDouble(String string, String string2, double d, double d2, boolean bl) throws ValidationException, IntrusionException {
        if (d > d2) {
            throw new ValidationException(string + ": Invalid double input: context", "Validation parameter error for double: maxValue ( " + d2 + ") must be greater than minValue ( " + d + ") for " + string, string);
        }
        if (this.isEmpty(string2)) {
            if (bl) {
                return null;
            }
            throw new ValidationException(string + ": Input required: context", "Input required: context=" + string + ", input=" + string2, string);
        }
        try {
            Double d3 = new Double(Double.parseDouble(string2));
            if (d3.isInfinite()) {
                throw new ValidationException("Invalid double input: context=" + string, "Invalid double input is infinite: context=" + string + ", input=" + string2, string);
            }
            if (d3.isNaN()) {
                throw new ValidationException("Invalid double input: context=" + string, "Invalid double input is infinite: context=" + string + ", input=" + string2, string);
            }
            if (d3 < d) {
                throw new ValidationException("Invalid double input must be between " + d + " and " + d2 + ": context=" + string, "Invalid double input must be between " + d + " and " + d2 + ": context=" + string + ", input=" + string2, string);
            }
            if (d3 > d2) {
                throw new ValidationException("Invalid double input must be between " + d + " and " + d2 + ": context=" + string, "Invalid double input must be between " + d + " and " + d2 + ": context=" + string + ", input=" + string2, string);
            }
            return d3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(string + ": Invalid double input", "Invalid double input format: context=" + string + ", input=" + string2, numberFormatException, string);
        }
    }

    public Double getValidDouble(String string, String string2, double d, double d2, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidDouble(string, string2, d, d2, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return new Double(0.0);
        }
    }

    public boolean isValidInteger(String string, String string2, int n, int n2, boolean bl) throws IntrusionException {
        try {
            this.getValidInteger(string, string2, n, n2, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Integer getValidInteger(String string, String string2, int n, int n2, boolean bl) throws ValidationException, IntrusionException {
        if (n > n2) {
            throw new ValidationException(string + ": Invalid Integer", "Validation parameter error for double: maxValue ( " + n2 + ") must be greater than minValue ( " + n + ") for " + string, string);
        }
        if (this.isEmpty(string2)) {
            if (bl) {
                return null;
            }
            throw new ValidationException(string + ": Input required", "Input required: context=" + string + ", input=" + string2, string);
        }
        try {
            int n3 = Integer.parseInt(string2);
            if (n3 < n || n3 > n2) {
                throw new ValidationException(string + ": Invalid Integer. Value must be between " + n + " and " + n2, "Invalid int input must be between " + n + " and " + n2 + ": context=" + string + ", input=" + string2, string);
            }
            return new Integer(n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(string + ": Invalid integer input", "Invalid int input: context=" + string + ", input=" + string2, numberFormatException, string);
        }
    }

    public Integer getValidInteger(String string, String string2, int n, int n2, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidInteger(string, string2, n, n2, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return new Integer(0);
        }
    }

    public boolean isValidFileContent(String string, byte[] byArray, int n, boolean bl) throws IntrusionException {
        try {
            this.getValidFileContent(string, byArray, n, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte[] getValidFileContent(String string, byte[] byArray, int n, boolean bl) throws ValidationException, IntrusionException {
        if (this.isEmpty(byArray)) {
            if (bl) {
                return null;
            }
            throw new ValidationException(string + ": Input required", "Input required: context=" + string + ", input=" + byArray, string);
        }
        long l = ESAPI.securityConfiguration().getAllowedFileUploadSize();
        if ((long)byArray.length > l) {
            throw new ValidationException(string + ": Invalid file content can not exceed " + l + " bytes", "Exceeded ESAPI max length", string);
        }
        if (byArray.length > n) {
            throw new ValidationException(string + ": Invalid file content can not exceed " + n + " bytes", "Exceeded maxBytes ( " + byArray.length + ")", string);
        }
        return byArray;
    }

    public byte[] getValidFileContent(String string, byte[] byArray, int n, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidFileContent(string, byArray, n, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return byArray;
        }
    }

    public boolean isValidFileUpload(String string, String string2, String string3, byte[] byArray, int n, boolean bl) throws IntrusionException {
        return this.isValidFileName(string, string3, bl) && this.isValidDirectoryPath(string, string2, bl) && this.isValidFileContent(string, byArray, n, bl);
    }

    public void assertValidFileUpload(String string, String string2, String string3, byte[] byArray, int n, boolean bl) throws ValidationException, IntrusionException {
        this.getValidFileName(string, string3, bl);
        this.getValidDirectoryPath(string, string2, bl);
        this.getValidFileContent(string, byArray, n, bl);
    }

    public void assertValidFileUpload(String string, String string2, String string3, byte[] byArray, int n, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            this.assertValidFileUpload(string, string2, string3, byArray, n, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
        }
    }

    public boolean isValidHTTPRequest() throws IntrusionException {
        try {
            this.assertIsValidHTTPRequest();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isValidHTTPRequest(HttpServletRequest httpServletRequest) throws IntrusionException {
        try {
            this.assertIsValidHTTPRequest(httpServletRequest);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void assertIsValidHTTPRequest() throws ValidationException, IntrusionException {
        SafeRequest safeRequest = ESAPI.httpUtilities().getCurrentRequest();
        this.assertIsValidHTTPRequest(safeRequest);
    }

    private void assertIsValidHTTPRequest(HttpServletRequest httpServletRequest) throws ValidationException, IntrusionException {
        Object object;
        Object object2;
        if (httpServletRequest == null) {
            throw new ValidationException("Input required: HTTP request is null", "Input required: HTTP request is null");
        }
        if (!httpServletRequest.getMethod().equals("GET") && !httpServletRequest.getMethod().equals("POST")) {
            throw new IntrusionException("Bad HTTP method received", "Bad HTTP method received: " + httpServletRequest.getMethod());
        }
        for (Map.Entry iterator2 : httpServletRequest.getParameterMap().entrySet()) {
            String string = (String)iterator2.getKey();
            this.getValidInput("HTTP request parameter: " + string, string, "HTTPParameterName", 100, false);
            object2 = (String[])iterator2.getValue();
            for (String string2 : Arrays.asList(object2)) {
                this.getValidInput("HTTP request parameter: " + string, string2, "HTTPParameterValue", 65535, true);
            }
        }
        if (httpServletRequest.getCookies() != null) {
            for (Cookie cookie : Arrays.asList(httpServletRequest.getCookies())) {
                object2 = cookie.getName();
                this.getValidInput("HTTP request cookie: " + (String)object2, (String)object2, "HTTPCookieName", 100, true);
                object = cookie.getValue();
                this.getValidInput("HTTP request cookie: " + (String)object2, (String)object, "HTTPCookieValue", 65535, true);
            }
        }
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == null || string.equalsIgnoreCase("Cookie")) continue;
            this.getValidInput("HTTP request header: " + string, string, "HTTPHeaderName", 100, true);
            object2 = httpServletRequest.getHeaders(string);
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.getValidInput("HTTP request header: " + string, (String)object, "HTTPHeaderValue", 65535, true);
            }
        }
    }

    public boolean isValidListItem(String string, String string2, List list) {
        try {
            this.getValidListItem(string, string2, list);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getValidListItem(String string, String string2, List list) throws ValidationException, IntrusionException {
        if (list.contains(string2)) {
            return string2;
        }
        throw new ValidationException(string + ": Invalid list item", "Invalid list item: context=" + string + ", input=" + string2, string);
    }

    public String getValidListItem(String string, String string2, List list, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidListItem(string, string2, list);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public boolean isValidHTTPRequestParameterSet(String string, Set set, Set set2) {
        try {
            this.assertIsValidHTTPRequestParameterSet(string, set, set2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void assertIsValidHTTPRequestParameterSet(String string, Set set, Set set2) throws ValidationException, IntrusionException {
        SafeRequest safeRequest = ESAPI.httpUtilities().getCurrentRequest();
        Set set3 = safeRequest.getParameterMap().keySet();
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(set3);
        if (hashSet.size() > 0) {
            throw new ValidationException(string + ": Invalid HTTP request missing parameters", "Invalid HTTP request missing parameters " + hashSet + ": context=" + string, string);
        }
        HashSet hashSet2 = new HashSet(set3);
        hashSet2.removeAll(set);
        hashSet2.removeAll(set2);
        if (hashSet2.size() > 0) {
            throw new ValidationException(string + ": Invalid HTTP request extra parameters " + hashSet2, "Invalid HTTP request extra parameters " + hashSet2 + ": context=" + string, string);
        }
    }

    public void assertIsValidHTTPRequestParameterSet(String string, Set set, Set set2, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            this.assertIsValidHTTPRequestParameterSet(string, set, set2);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
        }
    }

    public boolean isValidPrintable(String string, byte[] byArray, int n, boolean bl) throws IntrusionException {
        try {
            this.getValidPrintable(string, byArray, n, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte[] getValidPrintable(String string, byte[] byArray, int n, boolean bl) throws ValidationException, IntrusionException {
        if (this.isEmpty(byArray)) {
            if (bl) {
                return null;
            }
            throw new ValidationException(string + ": Input bytes required", "Input bytes required: HTTP request is null", string);
        }
        if (byArray.length > n) {
            throw new ValidationException(string + ": Input bytes can not exceed " + n + " bytes", "Input exceeds maximum allowed length of " + n + " by " + (byArray.length - n) + " bytes: context=" + string + ", input=" + byArray, string);
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 33 && byArray[i] <= 126) continue;
            throw new ValidationException(string + ": Invalid input bytes: context=" + string, "Invalid non-ASCII input bytes, context=" + string + ", input=" + byArray, string);
        }
        return byArray;
    }

    public byte[] getValidPrintable(String string, byte[] byArray, int n, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidPrintable(string, byArray, n, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return byArray;
        }
    }

    public boolean isValidPrintable(String string, String string2, int n, boolean bl) throws IntrusionException {
        try {
            this.getValidPrintable(string, string2, n, bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getValidPrintable(String string, String string2, int n, boolean bl) throws ValidationException, IntrusionException {
        String string3 = "";
        try {
            string3 = ESAPI.encoder().canonicalize(string2);
            return new String(this.getValidPrintable(string, string3.getBytes(), n, bl));
        }
        catch (EncodingException encodingException) {
            throw new ValidationException(string + ": Invalid printable input", "Invalid encoding of printable input, context=" + string + ", input=" + string2, encodingException, string);
        }
    }

    public String getValidPrintable(String string, String string2, int n, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidPrintable(string, string2, n, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public boolean isValidRedirectLocation(String string, String string2, boolean bl) throws IntrusionException {
        return ESAPI.validator().isValidInput(string, string2, "Redirect", 512, bl);
    }

    public String getValidRedirectLocation(String string, String string2, boolean bl) throws ValidationException, IntrusionException {
        return ESAPI.validator().getValidInput(string, string2, "Redirect", 512, bl);
    }

    public String getValidRedirectLocation(String string, String string2, boolean bl, ValidationErrorList validationErrorList) throws IntrusionException {
        try {
            return this.getValidRedirectLocation(string, string2, bl);
        }
        catch (ValidationException validationException) {
            validationErrorList.addError(string, validationException);
            return string2;
        }
    }

    public String safeReadLine(InputStream inputStream, int n) throws ValidationException {
        if (n <= 0) {
            throw new ValidationAvailabilityException("Invalid input", "Invalid readline. Must read a positive number of bytes from the stream");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        try {
            while (true) {
                int n3;
                if ((n3 = inputStream.read()) == -1) {
                    if (stringBuffer.length() != 0) break;
                    return null;
                }
                if (n3 == 10 || n3 == 13) break;
                if (++n2 > n) {
                    throw new ValidationAvailabilityException("Invalid input", "Invalid readLine. Read more than maximum characters allowed (" + n + ")");
                }
                stringBuffer.append((char)n3);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new ValidationAvailabilityException("Invalid input", "Invalid readLine. Problem reading from input stream", iOException);
        }
    }

    private final boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private final boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }
}

