/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;
import org.owasp.esapi.errors.AuthenticationAccountsException;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.AuthenticationHostException;
import org.owasp.esapi.errors.AuthenticationLoginException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.reference.DefaultEncoder;

public class DefaultUser
implements User,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int IDLE_TIMEOUT_LENGTH = ESAPI.securityConfiguration().getSessionIdleTimeoutLength();
    private static final int ABSOLUTE_TIMEOUT_LENGTH = ESAPI.securityConfiguration().getSessionAbsoluteTimeoutLength();
    private final Logger logger = ESAPI.getLogger("DefaultUser");
    long accountId = 0L;
    private String accountName = "";
    private String screenName = "";
    private String csrfToken = "";
    private Set roles = new HashSet();
    private boolean locked = false;
    private boolean loggedIn = true;
    private boolean enabled = false;
    private String lastHostAddress;
    private Date lastPasswordChangeTime = new Date(0L);
    private Date lastLoginTime = new Date(0L);
    private Date lastFailedLoginTime = new Date(0L);
    private Date expirationTime = new Date(Long.MAX_VALUE);
    private Set sessions = new HashSet();
    private int failedLoginCount = 0;
    private final int MAX_ROLE_LENGTH = 250;

    DefaultUser(String string) {
        long l;
        this.setAccountName(string);
        do {
            l = Math.abs(ESAPI.randomizer().getRandomLong());
        } while (ESAPI.authenticator().getUser(l) != null || l == 0L);
        this.setAccountId(l);
    }

    public void addRole(String string) throws AuthenticationException {
        String string2 = string.toLowerCase();
        if (!ESAPI.validator().isValidInput("addRole", string2, "RoleName", 250, false)) {
            throw new AuthenticationAccountsException("Add role failed", "Attempt to add invalid role " + string2 + " to " + this.getAccountName());
        }
        this.roles.add(string2);
        this.logger.info(Logger.SECURITY, true, "Role " + string2 + " added to " + this.getAccountName());
    }

    public void addRoles(Set set) throws AuthenticationException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.addRole((String)iterator.next());
        }
    }

    public void changePassword(String string, String string2, String string3) throws AuthenticationException, EncryptionException {
        ESAPI.authenticator().changePassword(this, string, string2, string3);
    }

    public void disable() {
        this.enabled = false;
        this.logger.info(Logger.SECURITY, true, "Account disabled: " + this.getAccountName());
    }

    public void enable() {
        this.enabled = true;
        this.logger.info(Logger.SECURITY, true, "Account enabled: " + this.getAccountName());
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getCSRFToken() {
        return this.csrfToken;
    }

    public Date getExpirationTime() {
        return (Date)this.expirationTime.clone();
    }

    public int getFailedLoginCount() {
        return this.failedLoginCount;
    }

    void setFailedLoginCount(int n) {
        this.failedLoginCount = n;
    }

    public Date getLastFailedLoginTime() {
        return (Date)this.lastFailedLoginTime.clone();
    }

    public String getLastHostAddress() {
        if (this.lastHostAddress == null) {
            return "local";
        }
        return this.lastHostAddress;
    }

    public Date getLastLoginTime() {
        return (Date)this.lastLoginTime.clone();
    }

    public Date getLastPasswordChangeTime() {
        return (Date)this.lastPasswordChangeTime.clone();
    }

    public String getName() {
        return this.getAccountName();
    }

    public Set getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void addSession(HttpSession httpSession) {
        this.sessions.add(httpSession);
    }

    public void removeSession(HttpSession httpSession) {
        this.sessions.remove(httpSession);
    }

    public Set getSessions() {
        return this.sessions;
    }

    public void incrementFailedLoginCount() {
        ++this.failedLoginCount;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExpired() {
        return this.getExpirationTime().before(new Date());
    }

    public boolean isInRole(String string) {
        return this.roles.contains(string.toLowerCase());
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isSessionAbsoluteTimeout() {
        HttpSession httpSession = ESAPI.httpUtilities().getCurrentRequest().getSession(false);
        if (httpSession == null) {
            return true;
        }
        Date date = new Date(httpSession.getCreationTime() + (long)ABSOLUTE_TIMEOUT_LENGTH);
        Date date2 = new Date();
        return date2.after(date);
    }

    public boolean isSessionTimeout() {
        HttpSession httpSession = ESAPI.httpUtilities().getCurrentRequest().getSession(false);
        if (httpSession == null) {
            return true;
        }
        Date date = new Date(httpSession.getLastAccessedTime() + (long)IDLE_TIMEOUT_LENGTH);
        Date date2 = new Date();
        return date2.after(date);
    }

    public void lock() {
        this.locked = true;
        this.logger.info(Logger.SECURITY, true, "Account locked: " + this.getAccountName());
    }

    public void loginWithPassword(String string) throws AuthenticationException {
        if (string == null || string.equals("")) {
            this.setLastFailedLoginTime(new Date());
            this.incrementFailedLoginCount();
            throw new AuthenticationLoginException("Login failed", "Missing password: " + this.accountName);
        }
        if (!this.isEnabled()) {
            this.setLastFailedLoginTime(new Date());
            this.incrementFailedLoginCount();
            throw new AuthenticationLoginException("Login failed", "Disabled user attempt to login: " + this.accountName);
        }
        if (this.isLocked()) {
            this.setLastFailedLoginTime(new Date());
            this.incrementFailedLoginCount();
            throw new AuthenticationLoginException("Login failed", "Locked user attempt to login: " + this.accountName);
        }
        if (this.isExpired()) {
            this.setLastFailedLoginTime(new Date());
            this.incrementFailedLoginCount();
            throw new AuthenticationLoginException("Login failed", "Expired user attempt to login: " + this.accountName);
        }
        this.logout();
        if (!this.verifyPassword(string)) {
            this.loggedIn = false;
            this.setLastFailedLoginTime(new Date());
            this.incrementFailedLoginCount();
            if (this.getFailedLoginCount() >= ESAPI.securityConfiguration().getAllowedLoginAttempts()) {
                this.lock();
            }
            throw new AuthenticationLoginException("Login failed", "Incorrect password provided for " + this.getAccountName());
        }
        this.loggedIn = true;
        ESAPI.httpUtilities().changeSessionIdentifier(ESAPI.currentRequest());
        ESAPI.authenticator().setCurrentUser(this);
        this.setLastLoginTime(new Date());
        this.setLastHostAddress(ESAPI.httpUtilities().getCurrentRequest().getRemoteHost());
        this.logger.trace(Logger.SECURITY, true, "User logged in: " + this.accountName);
    }

    public void logout() {
        ESAPI.httpUtilities().killCookie(ESAPI.currentRequest(), ESAPI.currentResponse(), "ESAPIRememberToken");
        HttpSession httpSession = ESAPI.currentRequest().getSession(false);
        if (httpSession != null) {
            this.removeSession(httpSession);
            httpSession.invalidate();
        }
        ESAPI.httpUtilities().killCookie(ESAPI.currentRequest(), ESAPI.currentResponse(), "JSESSIONID");
        this.loggedIn = false;
        this.logger.info(Logger.SECURITY, true, "Logout successful");
        ESAPI.authenticator().setCurrentUser(User.ANONYMOUS);
    }

    public void removeRole(String string) {
        this.roles.remove(string.toLowerCase());
        this.logger.trace(Logger.SECURITY, true, "Role " + string + " removed from " + this.getAccountName());
    }

    public String resetCSRFToken() {
        this.csrfToken = ESAPI.randomizer().getRandomString(8, DefaultEncoder.CHAR_ALPHANUMERICS);
        return this.csrfToken;
    }

    private void setAccountId(long l) {
        this.accountId = l;
    }

    public void setAccountName(String string) {
        String string2 = this.getAccountName();
        this.accountName = string.toLowerCase();
        if (string2 != null) {
            this.logger.info(Logger.SECURITY, true, "Account name changed from " + string2 + " to " + this.getAccountName());
        }
    }

    public void setExpirationTime(Date date) {
        this.expirationTime = new Date(date.getTime());
        this.logger.info(Logger.SECURITY, true, "Account expiration time set to " + date + " for " + this.getAccountName());
    }

    public void setLastFailedLoginTime(Date date) {
        this.lastFailedLoginTime = date;
        this.logger.info(Logger.SECURITY, true, "Set last failed login time to " + date + " for " + this.getAccountName());
    }

    public void setLastHostAddress(String string) {
        if (this.lastHostAddress != null && !this.lastHostAddress.equals(string)) {
            new AuthenticationHostException("Host change", "User session just jumped from " + this.lastHostAddress + " to " + string);
        }
        this.lastHostAddress = string;
    }

    public void setLastLoginTime(Date date) {
        this.lastLoginTime = date;
        this.logger.info(Logger.SECURITY, true, "Set last successful login time to " + date + " for " + this.getAccountName());
    }

    public void setLastPasswordChangeTime(Date date) {
        this.lastPasswordChangeTime = date;
        this.logger.info(Logger.SECURITY, true, "Set last password change time to " + date + " for " + this.getAccountName());
    }

    public void setRoles(Set set) throws AuthenticationException {
        this.roles = new HashSet();
        this.addRoles(set);
        this.logger.info(Logger.SECURITY, true, "Adding roles " + set + " to " + this.getAccountName());
    }

    public void setScreenName(String string) {
        this.screenName = string;
        this.logger.info(Logger.SECURITY, true, "ScreenName changed to " + string + " for " + this.getAccountName());
    }

    public String toString() {
        return "USER:" + this.accountName;
    }

    public void unlock() {
        this.locked = false;
        this.failedLoginCount = 0;
        this.logger.info(Logger.SECURITY, true, "Account unlocked: " + this.getAccountName());
    }

    public boolean verifyPassword(String string) {
        return ESAPI.authenticator().verifyPassword(this, string);
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

